/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import javax.xml.ws.WebServiceFeature;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.client.SecurityActions;
import org.jboss.wsf.stack.cxf.client.UseNewBusFeature;
import org.jboss.wsf.stack.cxf.client.UseTCCLBusFeature;
import org.jboss.wsf.stack.cxf.client.UseThreadBusFeature;

public abstract class ClientBusSelector {
    private static final String sysPropStrategy;

    public static String selectStrategy(WebServiceFeature ... features) {
        boolean createNewBus = false;
        boolean tcclBoundBus = false;
        boolean threadBus = false;
        int count = 0;
        if (features != null) {
            for (WebServiceFeature f : features) {
                String className = f.getClass().getName();
                if (UseNewBusFeature.class.getName().equals(className)) {
                    createNewBus = f.isEnabled();
                    ++count;
                    continue;
                }
                if (UseTCCLBusFeature.class.getName().equals(className)) {
                    tcclBoundBus = f.isEnabled();
                    ++count;
                    continue;
                }
                if (!UseThreadBusFeature.class.getName().equals(className)) continue;
                threadBus = f.isEnabled();
                ++count;
            }
        }
        if (count > 1) {
            throw Messages.MESSAGES.incompatibleJAXWSClientBusFeatureProvided();
        }
        String featureStrategy = null;
        if (createNewBus) {
            featureStrategy = "NEW_BUS";
        } else if (tcclBoundBus) {
            featureStrategy = "TCCL_BUS";
        } else if (threadBus) {
            featureStrategy = "THREAD_BUS";
        }
        return featureStrategy != null ? featureStrategy : sysPropStrategy;
    }

    public static String getDefaultStrategy() {
        return sysPropStrategy;
    }

    static {
        String propValue = SecurityActions.getSystemProperty("org.jboss.ws.cxf.jaxws-client.bus.strategy", "THREAD_BUS");
        if ("THREAD_BUS".equals(propValue) || "NEW_BUS".equals(propValue) || "TCCL_BUS".equals(propValue)) {
            sysPropStrategy = propValue;
        } else {
            Loggers.ROOT_LOGGER.unknownJAXWSClientBusStrategy(propValue);
            sysPropStrategy = "THREAD_BUS";
        }
    }
}

