/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.FilterConstants;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterParser;
import org.hornetq.core.filter.impl.Identifier;
import org.hornetq.core.filter.impl.Operator;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerMessage;

public class FilterImpl
implements Filter {
    private final SimpleString sfilterString;
    private final Map<SimpleString, Identifier> identifiers;
    private final Object result;
    private final Class<? extends Object> resultType;

    public static Filter createFilter(String filterStr) throws HornetQException {
        return FilterImpl.createFilter(SimpleString.toSimpleString((String)(filterStr == null ? null : filterStr.trim())));
    }

    public static Filter createFilter(SimpleString filterStr) throws HornetQException {
        Object result0;
        if (filterStr == null || filterStr.length() == 0) {
            return null;
        }
        HashMap<SimpleString, Identifier> identifierMap = new HashMap<SimpleString, Identifier>();
        try {
            result0 = new FilterParser().parse(filterStr, identifierMap);
        }
        catch (Throwable e) {
            HornetQServerLogger.LOGGER.invalidFilter(e, filterStr);
            throw HornetQMessageBundle.BUNDLE.invalidFilter(e, filterStr);
        }
        return new FilterImpl(filterStr, identifierMap, result0);
    }

    private FilterImpl(SimpleString str, HashMap<SimpleString, Identifier> identifierMap, Object result0) {
        this.sfilterString = str;
        this.identifiers = identifierMap;
        this.result = result0;
        this.resultType = this.result.getClass();
    }

    @Override
    public SimpleString getFilterString() {
        return this.sfilterString;
    }

    @Override
    public synchronized boolean match(ServerMessage message) {
        try {
            for (Identifier id : this.identifiers.values()) {
                Object val = null;
                if (id.getName().startsWith(FilterConstants.HORNETQ_PREFIX)) {
                    val = this.getHeaderFieldValue(message, id.getName());
                }
                if (val == null) {
                    val = message.getObjectProperty(id.getName());
                }
                id.setValue(val);
            }
            if (this.resultType.equals(Identifier.class)) {
                return (Boolean)((Identifier)this.result).getValue();
            }
            if (this.resultType.equals(Operator.class)) {
                Operator op = (Operator)this.result;
                Object result = op.apply();
                if (result == null) {
                    return false;
                }
                return (Boolean)result;
            }
            throw new Exception("Bad object type: " + this.result);
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.invalidFilter(e, this.sfilterString);
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sfilterString == null ? 0 : this.sfilterString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterImpl other = (FilterImpl)obj;
        return !(this.sfilterString == null ? other.sfilterString != null : !this.sfilterString.equals((Object)other.sfilterString));
    }

    public String toString() {
        return "FilterImpl [sfilterString=" + this.sfilterString + "]";
    }

    private Object getHeaderFieldValue(ServerMessage msg, SimpleString fieldName) {
        if (FilterConstants.HORNETQ_USERID.equals((Object)fieldName)) {
            return new SimpleString("ID:" + msg.getUserID());
        }
        if (FilterConstants.HORNETQ_PRIORITY.equals((Object)fieldName)) {
            return (int)msg.getPriority();
        }
        if (FilterConstants.HORNETQ_TIMESTAMP.equals((Object)fieldName)) {
            return msg.getTimestamp();
        }
        if (FilterConstants.HORNETQ_DURABLE.equals((Object)fieldName)) {
            return msg.isDurable() ? FilterConstants.DURABLE : FilterConstants.NON_DURABLE;
        }
        if (FilterConstants.HORNETQ_EXPIRATION.equals((Object)fieldName)) {
            return msg.getExpiration();
        }
        if (FilterConstants.HORNETQ_SIZE.equals((Object)fieldName)) {
            return msg.getEncodeSize();
        }
        return null;
    }
}

