/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.cloner;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.marshalling.AbstractObjectInput;
import org.jboss.marshalling.AbstractObjectOutput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerObjectInputStream;
import org.jboss.marshalling.MarshallerObjectOutputStream;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.CloneTable;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.util.BooleanReadField;
import org.jboss.marshalling.util.ByteReadField;
import org.jboss.marshalling.util.CharReadField;
import org.jboss.marshalling.util.DoubleReadField;
import org.jboss.marshalling.util.FloatReadField;
import org.jboss.marshalling.util.IdentityIntMap;
import org.jboss.marshalling.util.IntReadField;
import org.jboss.marshalling.util.Kind;
import org.jboss.marshalling.util.LongReadField;
import org.jboss.marshalling.util.ObjectReadField;
import org.jboss.marshalling.util.ReadField;
import org.jboss.marshalling.util.ShortReadField;

class SerializingCloner
implements ObjectCloner {
    private final CloneTable delegate;
    private final ObjectResolver objectResolver;
    private final ObjectResolver objectPreResolver;
    private final ClassCloner classCloner;
    private final SerializabilityChecker serializabilityChecker;
    private final int bufferSize;
    private final SerializableClassRegistry registry;
    private final IdentityHashMap<Object, Object> clones = new IdentityHashMap();
    private static final Set<Class<?>> UNCLONED;
    private static final IdentityIntMap<Class<?>> PRIMITIVE_ARRAYS;
    private static final Field proxyInvocationHandler;

    SerializingCloner(ClonerConfiguration configuration) {
        CloneTable delegate = configuration.getCloneTable();
        this.delegate = delegate == null ? CloneTable.NULL : delegate;
        ObjectResolver objectResolver = configuration.getObjectResolver();
        this.objectResolver = objectResolver == null ? Marshalling.nullObjectResolver() : objectResolver;
        ObjectResolver objectPreResolver = configuration.getObjectPreResolver();
        this.objectPreResolver = objectPreResolver == null ? Marshalling.nullObjectResolver() : objectPreResolver;
        ClassCloner classCloner = configuration.getClassCloner();
        this.classCloner = classCloner == null ? ClassCloner.IDENTITY : classCloner;
        SerializabilityChecker serializabilityChecker = configuration.getSerializabilityChecker();
        this.serializabilityChecker = serializabilityChecker == null ? SerializabilityChecker.DEFAULT : serializabilityChecker;
        int bufferSize = configuration.getBufferSize();
        this.bufferSize = bufferSize < 1 ? 8192 : bufferSize;
        this.registry = SerializableClassRegistry.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        SerializingCloner serializingCloner = this;
        synchronized (serializingCloner) {
            this.clones.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone(Object orig) throws IOException, ClassNotFoundException {
        SerializingCloner serializingCloner = this;
        synchronized (serializingCloner) {
            Object object;
            block7: {
                boolean ok = false;
                try {
                    Object clone = this.clone(orig, true);
                    ok = true;
                    object = clone;
                    if (ok) break block7;
                    this.reset();
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        this.reset();
                    }
                    throw throwable;
                }
            }
            return object;
        }
    }

    private Object clone(Object orig, boolean replace) throws IOException, ClassNotFoundException {
        Object clone;
        SerializableClass cloneInfo;
        boolean sameClass;
        if (orig == null) {
            return null;
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("Thread interrupted during cloning process");
        }
        IdentityHashMap<Object, Object> clones = this.clones;
        Object cached = clones.get(orig);
        if (cached != null) {
            return cached;
        }
        Object replaced = orig;
        replaced = this.objectPreResolver.writeReplace(replaced);
        ClassCloner classCloner = this.classCloner;
        if (replaced instanceof Class) {
            Class classObj = (Class)replaced;
            Class<?> clonedClass = Proxy.isProxyClass(classObj) ? classCloner.cloneProxy(classObj) : classCloner.clone(classObj);
            clones.put(replaced, clonedClass);
            return clonedClass;
        }
        cached = this.delegate.clone(replaced, this, classCloner);
        if (cached != null) {
            clones.put(replaced, cached);
            return cached;
        }
        Class<?> objClass = replaced.getClass();
        SerializableClass info = this.registry.lookup(objClass);
        if (replace) {
            if (info.hasWriteReplace()) {
                replaced = info.callWriteReplace(replaced);
            }
            if ((replaced = this.objectResolver.writeReplace(replaced)) != orig) {
                Object clone2 = this.clone(replaced, false);
                clones.put(orig, clone2);
                return clone2;
            }
        }
        if (orig instanceof Enum) {
            Class<Enum> cloneClass = ((Class)this.clone(objClass)).asSubclass(Enum.class);
            if (cloneClass == objClass) {
                return orig;
            }
            Class enumClass = ((Enum)orig).getDeclaringClass();
            Class<Enum> cloneEnumClass = enumClass == objClass ? cloneClass : ((Class)this.clone(enumClass)).asSubclass(Enum.class);
            return Enum.valueOf(cloneEnumClass, ((Enum)orig).name());
        }
        Class clonedClass = (Class)this.clone(objClass);
        if (Proxy.isProxyClass(objClass)) {
            return Proxy.newProxyInstance(clonedClass.getClassLoader(), clonedClass.getInterfaces(), (InvocationHandler)this.clone(SerializingCloner.getInvocationHandler(orig)));
        }
        if (UNCLONED.contains(objClass)) {
            return orig;
        }
        boolean bl = sameClass = objClass == clonedClass;
        if (objClass.isArray()) {
            Object simpleClone = SerializingCloner.simpleClone(orig, objClass);
            if (simpleClone != null) {
                return simpleClone;
            }
            Object[] origArray = (Object[])orig;
            int len = origArray.length;
            if (sameClass && len == 0) {
                clones.put(orig, orig);
                return orig;
            }
            if (UNCLONED.contains(objClass.getComponentType())) {
                Object[] clone3 = (Object[])origArray.clone();
                clones.put(orig, clone3);
                return clone3;
            }
            Object[] clone4 = sameClass ? (Object[])origArray.clone() : (Object[])Array.newInstance(clonedClass.getComponentType(), len);
            clones.put(orig, clone4);
            for (int i = 0; i < len; ++i) {
                clone4[i] = this.clone(origArray[i]);
            }
            return clone4;
        }
        SerializableClass serializableClass = cloneInfo = sameClass ? info : this.registry.lookup(clonedClass);
        if (orig instanceof Externalizable) {
            Externalizable externalizable = (Externalizable)orig;
            clone = cloneInfo.callNoArgConstructor();
            clones.put(orig, clone);
            ArrayDeque<Step> steps = new ArrayDeque<Step>();
            StepObjectOutput soo = new StepObjectOutput(steps);
            externalizable.writeExternal(soo);
            soo.doFinish();
            ((Externalizable)clone).readExternal(new StepObjectInput(steps));
        } else if (this.serializabilityChecker.isSerializable(objClass)) {
            clone = cloneInfo.callNonInitConstructor();
            if (!this.serializabilityChecker.isSerializable(clonedClass)) {
                throw new NotSerializableException(clonedClass.getName());
            }
            clones.put(orig, clone);
            this.initSerializableClone(orig, info, clone, cloneInfo);
        } else {
            throw new NotSerializableException(objClass.getName());
        }
        replaced = clone;
        if (cloneInfo.hasReadResolve()) {
            replaced = cloneInfo.callReadResolve(replaced);
        }
        if ((replaced = this.objectPreResolver.readResolve(this.objectResolver.readResolve(replaced))) != clone) {
            clones.put(orig, replaced);
        }
        return replaced;
    }

    private void initSerializableClone(Object orig, SerializableClass origInfo, Object clone, SerializableClass cloneInfo) throws IOException, ClassNotFoundException {
        Class<?> cloneClass = cloneInfo.getSubjectClass();
        if (!this.serializabilityChecker.isSerializable(cloneClass)) {
            throw new NotSerializableException(cloneClass.getName());
        }
        Class<?> cloneSuperClass = cloneClass.getSuperclass();
        Class<?> origClass = origInfo.getSubjectClass();
        Class<?> origSuperClass = origClass.getSuperclass();
        if (this.serializabilityChecker.isSerializable(origSuperClass) || this.serializabilityChecker.isSerializable(cloneSuperClass)) {
            this.initSerializableClone(orig, this.registry.lookup(origSuperClass), clone, this.registry.lookup(cloneSuperClass));
        }
        if (cloneClass != origClass && cloneClass != this.clone(origClass)) {
            if (cloneInfo.hasReadObjectNoData()) {
                cloneInfo.callReadObjectNoData(clone);
            }
            return;
        }
        if (!this.serializabilityChecker.isSerializable(origClass)) {
            if (cloneInfo.hasReadObjectNoData()) {
                cloneInfo.callReadObjectNoData(clone);
            }
            return;
        }
        ClonerPutField fields = new ClonerPutField();
        fields.defineFields(origInfo);
        if (origInfo.hasWriteObject()) {
            ArrayDeque<Step> steps = new ArrayDeque<Step>();
            StepObjectOutputStream stepObjectOutputStream = this.createStepObjectOutputStream(orig, fields, steps);
            origInfo.callWriteObject(orig, stepObjectOutputStream);
            stepObjectOutputStream.flush();
            stepObjectOutputStream.doFinish();
            this.cloneFields(fields);
            if (cloneInfo.hasReadObject()) {
                cloneInfo.callReadObject(clone, this.createStepObjectInputStream(clone, cloneInfo, fields, steps));
            } else {
                this.storeFields(cloneInfo, clone, fields);
            }
        } else {
            this.prepareFields(orig, fields);
            this.cloneFields(fields);
            if (cloneInfo.hasReadObject()) {
                cloneInfo.callReadObject(clone, this.createStepObjectInputStream(clone, cloneInfo, fields, new ArrayDeque<Step>()));
            } else {
                this.storeFields(cloneInfo, clone, fields);
            }
        }
    }

    private StepObjectInputStream createStepObjectInputStream(final Object clone, final SerializableClass cloneInfo, final ClonerPutField fields, final Queue<Step> steps) throws IOException {
        try {
            return System.getSecurityManager() == null ? new StepObjectInputStream(steps, fields, clone, cloneInfo) : AccessController.doPrivileged(new PrivilegedExceptionAction<StepObjectInputStream>(){

                @Override
                public StepObjectInputStream run() throws Exception {
                    return new StepObjectInputStream(steps, fields, clone, cloneInfo);
                }
            });
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Error er) {
                throw er;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    private StepObjectOutputStream createStepObjectOutputStream(final Object orig, final ClonerPutField fields, final Queue<Step> steps) throws IOException {
        try {
            return System.getSecurityManager() == null ? new StepObjectOutputStream(steps, fields, orig) : AccessController.doPrivileged(new PrivilegedExceptionAction<StepObjectOutputStream>(){

                @Override
                public StepObjectOutputStream run() throws IOException {
                    return new StepObjectOutputStream(steps, fields, orig);
                }
            });
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Error er) {
                throw er;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    private void prepareFields(Object subject, ClonerPutField fields) throws InvalidObjectException {
        Map defMap = fields.fieldDefMap;
        Map map = fields.fieldMap;
        try {
            block13: for (String name : defMap.keySet()) {
                SerializableField serializableField = (SerializableField)defMap.get(name);
                Field realField = serializableField.getField();
                if (realField == null) continue;
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        map.put(name, new BooleanReadField(serializableField, realField.getBoolean(subject)));
                        continue block13;
                    }
                    case BYTE: {
                        map.put(name, new ByteReadField(serializableField, realField.getByte(subject)));
                        continue block13;
                    }
                    case CHAR: {
                        map.put(name, new CharReadField(serializableField, realField.getChar(subject)));
                        continue block13;
                    }
                    case DOUBLE: {
                        map.put(name, new DoubleReadField(serializableField, realField.getDouble(subject)));
                        continue block13;
                    }
                    case FLOAT: {
                        map.put(name, new FloatReadField(serializableField, realField.getFloat(subject)));
                        continue block13;
                    }
                    case INT: {
                        map.put(name, new IntReadField(serializableField, realField.getInt(subject)));
                        continue block13;
                    }
                    case LONG: {
                        map.put(name, new LongReadField(serializableField, realField.getLong(subject)));
                        continue block13;
                    }
                    case OBJECT: {
                        map.put(name, new ObjectReadField(serializableField, realField.get(subject)));
                        continue block13;
                    }
                    case SHORT: {
                        map.put(name, new ShortReadField(serializableField, realField.getShort(subject)));
                        continue block13;
                    }
                }
                throw new IllegalStateException();
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidObjectException("Cannot access write field: " + e);
        }
    }

    private void cloneFields(ClonerPutField fields) throws IOException, ClassNotFoundException {
        Map defMap = fields.fieldDefMap;
        Map map = fields.fieldMap;
        for (String name : defMap.keySet()) {
            SerializableField field = (SerializableField)defMap.get(name);
            if (field.getKind() != Kind.OBJECT) continue;
            map.put(name, new ObjectReadField(field, this.clone(((ReadField)map.get(name)).getObject())));
        }
    }

    private void storeFields(SerializableClass cloneInfo, Object clone, ClonerPutField fields) throws IOException {
        Map map = fields.fieldMap;
        try {
            block13: for (SerializableField cloneField : cloneInfo.getFields()) {
                String name = cloneField.getName();
                ReadField field = (ReadField)map.get(name);
                Field realField = cloneField.getField();
                if (realField == null) continue;
                switch (cloneField.getKind()) {
                    case BOOLEAN: {
                        realField.setBoolean(clone, field == null ? false : field.getBoolean());
                        continue block13;
                    }
                    case BYTE: {
                        realField.setByte(clone, field == null ? (byte)0 : field.getByte());
                        continue block13;
                    }
                    case CHAR: {
                        realField.setChar(clone, field == null ? (char)'\u0000' : field.getChar());
                        continue block13;
                    }
                    case DOUBLE: {
                        realField.setDouble(clone, field == null ? 0.0 : field.getDouble());
                        continue block13;
                    }
                    case FLOAT: {
                        realField.setFloat(clone, field == null ? 0.0f : field.getFloat());
                        continue block13;
                    }
                    case INT: {
                        realField.setInt(clone, field == null ? 0 : field.getInt());
                        continue block13;
                    }
                    case LONG: {
                        realField.setLong(clone, field == null ? 0L : field.getLong());
                        continue block13;
                    }
                    case OBJECT: {
                        realField.set(clone, field == null ? null : field.getObject());
                        continue block13;
                    }
                    case SHORT: {
                        realField.setShort(clone, field == null ? (short)0 : field.getShort());
                        continue block13;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidObjectException("Cannot access write field: " + e);
        }
    }

    private static Object simpleClone(Object orig, Class<?> objClass) {
        int idx = PRIMITIVE_ARRAYS.get(objClass, -1);
        switch (idx) {
            case 0: {
                boolean[] booleans = (boolean[])orig;
                return booleans.length == 0 ? orig : booleans.clone();
            }
            case 1: {
                byte[] bytes = (byte[])orig;
                return bytes.length == 0 ? orig : bytes.clone();
            }
            case 2: {
                short[] shorts = (short[])orig;
                return shorts.length == 0 ? orig : shorts.clone();
            }
            case 3: {
                int[] ints = (int[])orig;
                return ints.length == 0 ? orig : ints.clone();
            }
            case 4: {
                long[] longs = (long[])orig;
                return longs.length == 0 ? orig : longs.clone();
            }
            case 5: {
                float[] floats = (float[])orig;
                return floats.length == 0 ? orig : floats.clone();
            }
            case 6: {
                double[] doubles = (double[])orig;
                return doubles.length == 0 ? orig : doubles.clone();
            }
            case 7: {
                char[] chars = (char[])orig;
                return chars.length == 0 ? orig : chars.clone();
            }
        }
        return null;
    }

    private static InvocationHandler getInvocationHandler(Object orig) {
        try {
            return (InvocationHandler)proxyInvocationHandler.get(orig);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    static {
        HashSet set = new HashSet();
        set.add(Boolean.class);
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Character.class);
        set.add(String.class);
        set.add(StackTraceElement.class);
        set.add(BigInteger.class);
        set.add(BigDecimal.class);
        set.add(Pattern.class);
        set.add(File.class);
        set.add(Collections.emptyList().getClass());
        set.add(Collections.emptySet().getClass());
        set.add(Collections.emptyMap().getClass());
        UNCLONED = set;
        IdentityIntMap<Class> map = new IdentityIntMap<Class>();
        map.put(boolean[].class, 0);
        map.put(byte[].class, 1);
        map.put(short[].class, 2);
        map.put(int[].class, 3);
        map.put(long[].class, 4);
        map.put(float[].class, 5);
        map.put(double[].class, 6);
        map.put(char[].class, 7);
        PRIMITIVE_ARRAYS = map;
        proxyInvocationHandler = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = Proxy.class.getDeclaredField("h");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
            }
        });
    }

    private static final class CloneStep
    extends Step {
        private final Object orig;

        private CloneStep(Object orig) {
            this.orig = orig;
        }

        Object getOrig() {
            return this.orig;
        }
    }

    private static final class ByteDataStep
    extends Step {
        private final byte[] bytes;

        private ByteDataStep(byte[] bytes) {
            this.bytes = bytes;
        }

        byte[] getBytes() {
            return this.bytes;
        }
    }

    class StepObjectInput
    extends AbstractObjectInput
    implements Unmarshaller {
        private final Queue<Step> steps;
        private Step current;
        private int idx;

        StepObjectInput(final Queue<Step> steps) throws IOException {
            super(SerializingCloner.this.bufferSize);
            this.steps = steps;
            this.current = steps.poll();
            super.start(new ByteInput(){

                @Override
                public int read() throws IOException {
                    while (StepObjectInput.this.current != null) {
                        if (StepObjectInput.this.current instanceof ByteDataStep) {
                            ByteDataStep step = (ByteDataStep)StepObjectInput.this.current;
                            byte[] bytes = step.getBytes();
                            if (StepObjectInput.this.idx == bytes.length) {
                                StepObjectInput.this.current = (Step)steps.poll();
                                StepObjectInput.this.idx = 0;
                                continue;
                            }
                            byte b = bytes[StepObjectInput.this.idx++];
                            return b & 0xFF;
                        }
                        return -1;
                    }
                    return -1;
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (len == 0) {
                        return 0;
                    }
                    int t = 0;
                    while (StepObjectInput.this.current != null && len > 0) {
                        if (StepObjectInput.this.current instanceof ByteDataStep) {
                            ByteDataStep step = (ByteDataStep)StepObjectInput.this.current;
                            byte[] bytes = step.getBytes();
                            int blen = bytes.length;
                            if (StepObjectInput.this.idx == blen) {
                                StepObjectInput.this.current = (Step)steps.poll();
                                StepObjectInput.this.idx = 0;
                                continue;
                            }
                            int c = Math.min(blen - StepObjectInput.this.idx, len);
                            System.arraycopy(bytes, StepObjectInput.this.idx, b, off, c);
                            StepObjectInput.this.idx += c;
                            off += c;
                            len -= c;
                            t += c;
                            if (StepObjectInput.this.idx != blen) continue;
                            StepObjectInput.this.current = (Step)steps.poll();
                            StepObjectInput.this.idx = 0;
                            continue;
                        }
                        return t == 0 ? -1 : t;
                    }
                    return t == 0 ? -1 : t;
                }

                @Override
                public int available() throws IOException {
                    return StepObjectInput.this.current instanceof ByteDataStep ? ((ByteDataStep)StepObjectInput.this.current).getBytes().length - StepObjectInput.this.idx : 0;
                }

                @Override
                public long skip(long n) throws IOException {
                    long t = 0L;
                    while (StepObjectInput.this.current != null && n > 0L) {
                        if (StepObjectInput.this.current instanceof ByteDataStep) {
                            ByteDataStep step = (ByteDataStep)StepObjectInput.this.current;
                            byte[] bytes = step.getBytes();
                            int blen = bytes.length;
                            if (StepObjectInput.this.idx == blen) {
                                StepObjectInput.this.current = (Step)steps.poll();
                                StepObjectInput.this.idx = 0;
                                continue;
                            }
                            int c = (int)Math.min((long)blen - (long)StepObjectInput.this.idx, n);
                            StepObjectInput.this.idx += c;
                            n -= (long)c;
                            if (StepObjectInput.this.idx != blen) continue;
                            StepObjectInput.this.current = (Step)steps.poll();
                            StepObjectInput.this.idx = 0;
                            continue;
                        }
                        return t;
                    }
                    return t;
                }

                @Override
                public void close() throws IOException {
                    StepObjectInput.this.current = null;
                }
            });
        }

        @Override
        protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
            Step step = this.current;
            while (step instanceof ByteDataStep) {
                step = this.steps.poll();
            }
            if (step == null) {
                this.current = null;
                throw new EOFException();
            }
            this.current = this.steps.poll();
            Object clone = SerializingCloner.this.clone(((CloneStep)step).getOrig());
            return clone;
        }

        @Override
        public void finish() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void start(ByteInput byteInput) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearInstanceCache() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearClassCache() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    class ClonerPutField
    extends ObjectOutputStream.PutField {
        private final Map<String, SerializableField> fieldDefMap = new HashMap<String, SerializableField>();
        private final Map<String, ReadField> fieldMap = new HashMap<String, ReadField>();

        ClonerPutField() {
        }

        private SerializableField getField(String name, Kind kind) {
            SerializableField field = this.fieldDefMap.get(name);
            if (field == null) {
                throw new IllegalArgumentException("No field named '" + name + "' could be found");
            }
            if (field.getKind() != kind) {
                throw new IllegalArgumentException("Field '" + name + "' is the wrong type (expected " + (Object)((Object)kind) + ", got " + (Object)((Object)field.getKind()) + ")");
            }
            return field;
        }

        private void defineFields(SerializableClass clazz) {
            for (SerializableField field : clazz.getFields()) {
                this.fieldDefMap.put(field.getName(), field);
            }
        }

        @Override
        public void put(String name, boolean val) {
            this.fieldMap.put(name, new BooleanReadField(this.getField(name, Kind.BOOLEAN), val));
        }

        @Override
        public void put(String name, byte val) {
            this.fieldMap.put(name, new ByteReadField(this.getField(name, Kind.BYTE), val));
        }

        @Override
        public void put(String name, char val) {
            this.fieldMap.put(name, new CharReadField(this.getField(name, Kind.CHAR), val));
        }

        @Override
        public void put(String name, short val) {
            this.fieldMap.put(name, new ShortReadField(this.getField(name, Kind.SHORT), val));
        }

        @Override
        public void put(String name, int val) {
            this.fieldMap.put(name, new IntReadField(this.getField(name, Kind.INT), val));
        }

        @Override
        public void put(String name, long val) {
            this.fieldMap.put(name, new LongReadField(this.getField(name, Kind.LONG), val));
        }

        @Override
        public void put(String name, float val) {
            this.fieldMap.put(name, new FloatReadField(this.getField(name, Kind.FLOAT), val));
        }

        @Override
        public void put(String name, double val) {
            this.fieldMap.put(name, new DoubleReadField(this.getField(name, Kind.DOUBLE), val));
        }

        @Override
        public void put(String name, Object val) {
            this.fieldMap.put(name, new ObjectReadField(this.getField(name, Kind.OBJECT), val));
        }

        @Override
        @Deprecated
        public void write(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    class StepObjectInputStream
    extends MarshallerObjectInputStream {
        private final ClonerPutField clonerPutField;
        private final Object clone;
        private final SerializableClass cloneInfo;

        StepObjectInputStream(Queue<Step> steps, ClonerPutField clonerPutField, Object clone, SerializableClass cloneInfo) throws IOException {
            super(new StepObjectInput(steps));
            this.clonerPutField = clonerPutField;
            this.clone = clone;
            this.cloneInfo = cloneInfo;
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            SerializingCloner.this.storeFields(this.cloneInfo, this.clone, this.clonerPutField);
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            return new ObjectInputStream.GetField(){

                @Override
                public ObjectStreamClass getObjectStreamClass() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean defaulted(String name) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted();
                }

                @Override
                public boolean get(String name, boolean val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getBoolean();
                }

                @Override
                public byte get(String name, byte val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getByte();
                }

                @Override
                public char get(String name, char val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getChar();
                }

                @Override
                public short get(String name, short val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getShort();
                }

                @Override
                public int get(String name, int val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getInt();
                }

                @Override
                public long get(String name, long val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getLong();
                }

                @Override
                public float get(String name, float val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getFloat();
                }

                @Override
                public double get(String name, double val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getDouble();
                }

                @Override
                public Object get(String name, Object val) throws IOException {
                    ReadField field = (ReadField)StepObjectInputStream.this.clonerPutField.fieldMap.get(name);
                    return field == null || field.isDefaulted() ? val : field.getObject();
                }
            };
        }

        @Override
        public void registerValidation(ObjectInputValidation obj, int priority) throws NotActiveException, InvalidObjectException {
        }
    }

    class StepObjectOutputStream
    extends MarshallerObjectOutputStream {
        private final Queue<Step> steps;
        private final ClonerPutField clonerPutField;
        private final Object subject;
        private final StepObjectOutput output;

        private StepObjectOutputStream(StepObjectOutput output, Queue<Step> steps, ClonerPutField clonerPutField, Object subject) throws IOException {
            super(output);
            this.output = output;
            this.steps = steps;
            this.clonerPutField = clonerPutField;
            this.subject = subject;
        }

        StepObjectOutputStream(Queue<Step> steps, ClonerPutField clonerPutField, Object subject) throws IOException {
            this(serializingCloner.new StepObjectOutput(steps), steps, clonerPutField, subject);
        }

        @Override
        public void writeFields() throws IOException {
            if (!this.steps.isEmpty()) {
                throw new IllegalStateException("writeFields may not be called in this context");
            }
        }

        @Override
        public ObjectOutputStream.PutField putFields() throws IOException {
            if (!this.steps.isEmpty()) {
                throw new IllegalStateException("putFields may not be called in this context");
            }
            return this.clonerPutField;
        }

        @Override
        public void defaultWriteObject() throws IOException {
            if (!this.steps.isEmpty()) {
                throw new IllegalStateException("defaultWriteObject may not be called in this context");
            }
            Object subject = this.subject;
            ClonerPutField fields = this.clonerPutField;
            SerializingCloner.this.prepareFields(subject, fields);
        }

        void doFinish() throws IOException {
            this.output.doFinish();
        }
    }

    class StepObjectOutput
    extends AbstractObjectOutput
    implements Marshaller {
        private final Queue<Step> steps;
        private final ByteArrayOutputStream byteArrayOutputStream;

        StepObjectOutput(Queue<Step> steps) throws IOException {
            super(SerializingCloner.this.bufferSize);
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.steps = steps;
            super.start(Marshalling.createByteOutput(this.byteArrayOutputStream));
        }

        @Override
        protected void doWriteObject(Object obj, boolean unshared) throws IOException {
            super.flush();
            ByteArrayOutputStream baos = this.byteArrayOutputStream;
            if (baos.size() > 0) {
                this.steps.add(new ByteDataStep(baos.toByteArray()));
                baos.reset();
            }
            this.steps.add(new CloneStep(obj));
        }

        @Override
        public void clearInstanceCache() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearClassCache() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void start(ByteOutput byteOutput) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void finish() throws IOException {
            throw new UnsupportedOperationException();
        }

        void doFinish() throws IOException {
            super.finish();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            ByteArrayOutputStream baos = this.byteArrayOutputStream;
            if (baos.size() > 0) {
                this.steps.add(new ByteDataStep(baos.toByteArray()));
                baos.reset();
            }
        }
    }

    private static abstract class Step {
        private Step() {
        }
    }
}

