/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.service.HandlerChainService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

final class HandlerChainAdd
extends AbstractAddStepHandler {
    static final HandlerChainAdd INSTANCE = new HandlerChainAdd();

    private HandlerChainAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        super.rollbackRuntime(context, operation, model, controllers);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        if (context.isBooting()) {
            String protocolBindings = HandlerChainAdd.getAttributeValue(operation, "protocol-bindings");
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainType = address.getElement(address.size() - 1).getKey();
            String handlerChainId = address.getElement(address.size() - 1).getValue();
            ServiceName configServiceName = PackageUtils.getConfigServiceName(configType, configName);
            if (context.getServiceRegistry(false).getService(configServiceName) == null) {
                throw WSMessages.MESSAGES.missingConfig(configName);
            }
            ServiceName handlerChainServiceName = PackageUtils.getHandlerChainServiceName(configServiceName, handlerChainType, handlerChainId);
            HandlerChainService service = new HandlerChainService(handlerChainType, handlerChainId, protocolBindings);
            ServiceTarget target = context.getServiceTarget();
            ServiceBuilder handlerChainServiceBuilder = target.addService(handlerChainServiceName, (Service)service);
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, handlerChainServiceName, address, "handler")) {
                handlerChainServiceBuilder.addDependency(sn, UnifiedHandlerMetaData.class, service.getHandlersInjector());
            }
            ServiceController controller = handlerChainServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            if (newControllers != null) {
                newControllers.add(controller);
            }
        } else {
            context.reloadRequired();
        }
    }

    private static String getAttributeValue(ModelNode node, String propertyName) {
        return node.hasDefined(propertyName) ? node.get(propertyName).asString() : null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.PROTOCOL_BINDINGS.validateAndSet(operation, model);
    }
}

