/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.metadata.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.IndexDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.PropertyDescriptor;
import org.hibernate.search.metadata.impl.FieldDescriptorImpl;
import org.hibernate.search.metadata.impl.IndexDescriptorImpl;
import org.hibernate.search.metadata.impl.NumericFieldDescriptorImpl;
import org.hibernate.search.metadata.impl.PropertyDescriptorImpl;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IndexedTypeDescriptorImpl
implements IndexedTypeDescriptor {
    private static final Log log = LoggerFactory.make();
    private final Class<?> indexedType;
    private final float classBoost;
    private final BoostStrategy boostStrategy;
    private final Map<String, PropertyDescriptor> keyedPropertyDescriptors;
    private final Set<PropertyDescriptor> propertyDescriptors;
    private final Set<FieldDescriptor> classBridgeFieldDescriptors;
    private final Set<IndexDescriptor> indexDescriptors;
    private final Map<String, FieldDescriptor> allFieldDescriptors;
    private final boolean sharded;

    public IndexedTypeDescriptorImpl(TypeMetadata typeMetadata, IndexManager[] indexManagers) {
        this.indexedType = typeMetadata.getType();
        this.classBoost = typeMetadata.getStaticBoost();
        this.boostStrategy = typeMetadata.getDynamicBoost();
        this.sharded = indexManagers.length > 1;
        HashSet<NumericFieldDescriptorImpl> fieldDescriptorTmp = new HashSet<NumericFieldDescriptorImpl>();
        for (DocumentFieldMetadata documentFieldMetadata : typeMetadata.getClassBridgeMetadata()) {
            FieldDescriptorImpl fieldDescriptor = documentFieldMetadata.isNumeric() ? new NumericFieldDescriptorImpl(documentFieldMetadata) : new FieldDescriptorImpl(documentFieldMetadata);
            fieldDescriptorTmp.add((NumericFieldDescriptorImpl)fieldDescriptor);
        }
        this.classBridgeFieldDescriptors = Collections.unmodifiableSet(fieldDescriptorTmp);
        this.keyedPropertyDescriptors = Collections.unmodifiableMap(this.createPropertyDescriptors(typeMetadata));
        this.propertyDescriptors = Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.createPropertyDescriptors(typeMetadata).values()));
        this.allFieldDescriptors = Collections.unmodifiableMap(this.createAllFieldDescriptors());
        HashSet<IndexDescriptorImpl> indexDescriptorTmp = new HashSet<IndexDescriptorImpl>();
        for (IndexManager indexManager : indexManagers) {
            indexDescriptorTmp.add(new IndexDescriptorImpl(indexManager));
        }
        this.indexDescriptors = Collections.unmodifiableSet(indexDescriptorTmp);
    }

    @Override
    public Class<?> getType() {
        return this.indexedType;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public boolean isSharded() {
        return this.sharded;
    }

    @Override
    public float getStaticBoost() {
        return this.classBoost;
    }

    @Override
    public BoostStrategy getDynamicBoost() {
        return this.boostStrategy;
    }

    @Override
    public Set<IndexDescriptor> getIndexDescriptors() {
        return this.indexDescriptors;
    }

    @Override
    public Set<PropertyDescriptor> getIndexedProperties() {
        return this.propertyDescriptors;
    }

    @Override
    public PropertyDescriptor getProperty(String propertyName) {
        if (propertyName == null) {
            throw log.getPropertyNameCannotBeNullException();
        }
        for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public Set<FieldDescriptor> getIndexedFields() {
        return this.classBridgeFieldDescriptors;
    }

    @Override
    public FieldDescriptor getIndexedField(String fieldName) {
        if (fieldName == null) {
            throw log.getFieldNameCannotBeNullException();
        }
        return this.allFieldDescriptors.get(fieldName);
    }

    @Override
    public Set<FieldDescriptor> getFieldsForProperty(String propertyName) {
        if (propertyName == null) {
            throw log.getPropertyNameCannotBeNullException();
        }
        if (this.keyedPropertyDescriptors.containsKey(propertyName)) {
            return this.keyedPropertyDescriptors.get(propertyName).getIndexedFields();
        }
        return Collections.emptySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexedTypeDescriptorImpl{");
        sb.append("indexedType=").append(this.indexedType);
        sb.append(", classBoost=").append(this.classBoost);
        sb.append(", boostStrategy=").append(this.boostStrategy);
        sb.append(", keyedPropertyDescriptors=").append(this.keyedPropertyDescriptors);
        sb.append(", propertyDescriptors=").append(this.propertyDescriptors);
        sb.append(", classBridgeFieldDescriptors=").append(this.classBridgeFieldDescriptors);
        sb.append(", indexDescriptors=").append(this.indexDescriptors);
        sb.append(", allFieldDescriptors=").append(this.allFieldDescriptors);
        sb.append(", sharded=").append(this.sharded);
        sb.append('}');
        return sb.toString();
    }

    private Map<String, PropertyDescriptor> createPropertyDescriptors(TypeMetadata typeMetadata) {
        HashMap<String, PropertyDescriptor> propertyDescriptorsTmp = new HashMap<String, PropertyDescriptor>();
        for (PropertyMetadata propertyMetadata : typeMetadata.getAllPropertyMetadata()) {
            this.createOrMergeProperDescriptor(propertyDescriptorsTmp, propertyMetadata);
        }
        this.createOrMergeProperDescriptor(propertyDescriptorsTmp, typeMetadata.getIdPropertyMetadata());
        return propertyDescriptorsTmp;
    }

    private void createOrMergeProperDescriptor(Map<String, PropertyDescriptor> propertyDescriptorsTmp, PropertyMetadata propertyMetadata) {
        String propertyName = propertyMetadata.getPropertyAccessorName();
        HashSet<FieldDescriptor> tmpSet = new HashSet<FieldDescriptor>();
        if (propertyDescriptorsTmp.containsKey(propertyName)) {
            tmpSet.addAll(propertyDescriptorsTmp.get(propertyName).getIndexedFields());
        }
        boolean id = false;
        for (DocumentFieldMetadata documentFieldMetadata : propertyMetadata.getFieldMetadata()) {
            if (documentFieldMetadata.isId()) {
                id = true;
            }
            FieldDescriptorImpl fieldDescriptor = documentFieldMetadata.isNumeric() ? new NumericFieldDescriptorImpl(documentFieldMetadata) : new FieldDescriptorImpl(documentFieldMetadata);
            tmpSet.add(fieldDescriptor);
        }
        PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(propertyMetadata.getPropertyAccessorName(), id, tmpSet);
        propertyDescriptorsTmp.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    private Map<String, FieldDescriptor> createAllFieldDescriptors() {
        HashMap<String, FieldDescriptor> fieldDescriptorMap = new HashMap<String, FieldDescriptor>();
        for (FieldDescriptor fieldDescriptor : this.classBridgeFieldDescriptors) {
            fieldDescriptorMap.put(fieldDescriptor.getName(), fieldDescriptor);
        }
        for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
            for (FieldDescriptor fieldDescriptor : propertyDescriptor.getIndexedFields()) {
                fieldDescriptorMap.put(fieldDescriptor.getName(), fieldDescriptor);
            }
        }
        return fieldDescriptorMap;
    }
}

