/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.spi;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;

public class AbstractBeanAdapter
extends BeanAdapter {
    private BeanInfo beanInfo;
    private MethodInfo factory;
    private boolean constructed = false;
    private Object value;

    public AbstractBeanAdapter(BeanAdapterFactory beanAdapterFactory, BeanInfo beanInfo, MethodInfo factory) {
        super(beanAdapterFactory);
        if (beanInfo == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        this.beanInfo = beanInfo;
        this.factory = factory;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public MethodInfo getFactory() {
        return this.factory;
    }

    public Object get(PropertyInfo propertyInfo) throws Throwable {
        this.ensureConstructed();
        return propertyInfo.get(this.value);
    }

    public void set(PropertyInfo propertyInfo, Object child) throws Throwable {
        this.ensureConstructed();
        propertyInfo.set(this.value, child);
    }

    public Object getValue() {
        this.ensureConstructed();
        return this.value;
    }

    protected Object construct() {
        try {
            if (this.factory != null) {
                return this.factory.invoke(null, null);
            }
            return this.beanInfo.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error instantiating bean for " + this.beanInfo.getName(), t);
        }
    }

    protected void ensureConstructed() {
        if (!this.constructed) {
            this.value = this.construct();
            this.constructed = true;
        }
    }
}

