/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;

public class CorbaLoc {
    private final ORB orb;
    private String keyString;
    private byte[] key;
    private String bodyString;
    private boolean is_rir;
    public Profile[] profileList;

    public CorbaLoc(ORB orb, String addr) {
        this.orb = orb;
        this.is_rir = false;
        this.parse(addr);
    }

    public boolean rir() {
        return this.is_rir;
    }

    public String toString() {
        return "corbaloc:" + this.body();
    }

    private String body() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.bodyString);
        if (this.keyString != null) {
            buffer.append('/');
            buffer.append(this.keyString);
        }
        return buffer.toString();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public byte[] getKey() {
        return this.key;
    }

    private void defaultKeyString(String defaultKey) {
        if (this.keyString != null) {
            throw new IllegalStateException("KeyString not empty, cannot default to " + defaultKey);
        }
        this.keyString = defaultKey;
    }

    public String toCorbaName(String str_name) {
        if (this.getKeyString() == null) {
            this.defaultKeyString("NameService");
        }
        if (str_name != null && str_name.length() > 0) {
            try {
                return "corbaname:" + this.body() + "#" + str_name;
            }
            catch (Exception e) {
                return null;
            }
        }
        return "corbaname:" + this.body();
    }

    private void parse(String addr) {
        String sb;
        if (addr == null || !addr.startsWith("corbaloc:")) {
            throw new IllegalArgumentException("URL must start with 'corbaloc:'");
        }
        if (addr.indexOf(47) == -1) {
            sb = addr.substring(addr.indexOf(58) + 1);
            if (addr.startsWith("corbaloc:rir:")) {
                this.is_rir = true;
                this.keyString = "NameService";
            } else {
                this.keyString = null;
            }
            this.key = new byte[0];
        } else {
            sb = addr.substring(addr.indexOf(58) + 1, addr.indexOf(47));
            this.keyString = addr.substring(addr.indexOf(47) + 1);
            this.key = CorbaLoc.parseKey(this.keyString);
        }
        if (sb.indexOf(44) > 0) {
            StringTokenizer tokenizer = new StringTokenizer(sb, ",");
            this.profileList = new Profile[tokenizer.countTokens()];
            int pIndex = 0;
            for (int i = 0; i < this.profileList.length; ++i) {
                Profile p = this.parseAddress(tokenizer.nextToken());
                if (p == null) continue;
                this.profileList[pIndex] = p;
                ++pIndex;
            }
            while (pIndex < this.profileList.length) {
                this.profileList[pIndex] = null;
                ++pIndex;
            }
        } else {
            this.profileList = new Profile[]{this.parseAddress(sb)};
        }
        this.bodyString = sb;
    }

    private Profile parseAddress(String addr) {
        int colon = addr.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Illegal object address format: " + addr);
        }
        if ("rir:".equals(addr)) {
            this.is_rir = true;
            return null;
        }
        Profile result = null;
        if (this.orb == null && (colon == 0 || addr.startsWith("iiop:") || addr.startsWith("ssliop:"))) {
            result = new IIOPProfile(addr);
        } else if (this.orb != null) {
            List factories = this.orb.getTransportManager().getFactoriesList();
            Iterator i = factories.iterator();
            while (result == null && i.hasNext()) {
                Factories f = (Factories)i.next();
                result = f.decode_corbaloc(addr);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown protocol in object address format: " + addr);
        }
        return result;
    }

    private static boolean legalChar(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == ';' || c == '/' || c == ':' || c == '?' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '-' || c == '(' || c == ')';
    }

    private static byte hexValue(char c) {
        return (byte)(c >= 'a' ? 10 + c - 97 : (c >= 'A' ? 10 + c - 65 : c - 48));
    }

    private static char hexDigit(byte b) {
        if ((b & 0xF0) != 0) {
            throw new IllegalArgumentException("Hex digit out of range " + b);
        }
        return (char)(b < 10 ? 48 + (char)b : 65 + (char)b - 10);
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static byte[] parseKey(String s) {
        char[] tmp = s.toCharArray();
        int count = tmp.length;
        for (int i = 0; i < tmp.length; ++i) {
            if (CorbaLoc.legalChar(tmp[i])) continue;
            if (tmp[i] == '%') {
                if (CorbaLoc.isHex(tmp[i + 1]) && CorbaLoc.isHex(tmp[i + 2])) {
                    count -= 2;
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Illegal escape in URL character");
            }
            throw new IllegalArgumentException("URL character out of range: " + tmp[i]);
        }
        byte[] result = new byte[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            if (CorbaLoc.legalChar(tmp[idx])) {
                result[i] = (byte)tmp[idx++];
                continue;
            }
            result[i] = (byte)(CorbaLoc.hexValue(tmp[idx + 1]) << 4 | CorbaLoc.hexValue(tmp[idx + 2]));
            idx += 3;
        }
        return result;
    }

    public static String parseKey(byte[] key) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            if (!CorbaLoc.legalChar((char)key[i])) {
                buffer.append('%');
                buffer.append(CorbaLoc.hexDigit((byte)((key[i] & 0xFF) >> 4)));
                buffer.append(CorbaLoc.hexDigit((byte)(key[i] & 0xF)));
                continue;
            }
            buffer.append((char)key[i]);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        String[] noarg = new String[]{};
        ORB orb = (ORB)ORB.init(noarg, null);
        for (int i = 0; i < args.length; ++i) {
            System.out.println(new CorbaLoc(orb, args[i]).toString());
        }
    }
}

