/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.spring.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

public class NamespaceHandlerResolver
extends DefaultNamespaceHandlerResolver {
    public static final String JBOSSWS_HANDLER_MAPPINGS_LOCATION = "META-INF/jbossws.spring.handlers";
    private ClassLoader loader;
    private Map<Object, Object> jbosswsHandlerMappings;

    public NamespaceHandlerResolver() {
    }

    public NamespaceHandlerResolver(ClassLoader classLoader) {
        super(classLoader);
        this.loader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public NamespaceHandlerResolver(ClassLoader classLoader, String handlerMappingsLocation) {
        super(classLoader, handlerMappingsLocation);
        this.loader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public NamespaceHandler resolve(String namespaceUri) {
        NamespaceHandler jbosswsHandler = null;
        try {
            jbosswsHandler = this.resolveInternal(namespaceUri);
        }
        catch (Throwable t) {
            Loggers.ROOT_LOGGER.unableToResolveJBWSSpringNSHandler(namespaceUri, t);
        }
        return jbosswsHandler != null ? jbosswsHandler : super.resolve(namespaceUri);
    }

    private NamespaceHandler resolveInternal(String namespaceUri) {
        Map<Object, Object> handlerMappings = this.getHandlerMappings();
        Object handlerOrClassName = handlerMappings.get(namespaceUri);
        if (handlerOrClassName == null) {
            return null;
        }
        if (handlerOrClassName instanceof NamespaceHandler) {
            return (NamespaceHandler)handlerOrClassName;
        }
        String className = (String)handlerOrClassName;
        try {
            Class handlerClass = ClassUtils.forName((String)className, (ClassLoader)this.loader);
            if (!NamespaceHandler.class.isAssignableFrom(handlerClass)) {
                throw new FatalBeanException("", (Throwable)Messages.MESSAGES.nsHandlerInterfaceNotImplemented(className, namespaceUri, NamespaceHandler.class.getName()));
            }
            NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass((Class)handlerClass);
            namespaceHandler.init();
            handlerMappings.put(namespaceUri, namespaceHandler);
            return namespaceHandler;
        }
        catch (ClassNotFoundException ex) {
            throw new FatalBeanException("", (Throwable)Messages.MESSAGES.nsHandlerClassNotFound(className, namespaceUri, (Throwable)ex));
        }
        catch (LinkageError err) {
            throw new FatalBeanException("", (Throwable)Messages.MESSAGES.nsHandlerInvalidClass(className, namespaceUri, (Throwable)err));
        }
    }

    private Map<Object, Object> getHandlerMappings() {
        if (this.jbosswsHandlerMappings == null) {
            try {
                Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)JBOSSWS_HANDLER_MAPPINGS_LOCATION, (ClassLoader)this.loader);
                this.jbosswsHandlerMappings = new HashMap<Object, Object>(mappings);
            }
            catch (IOException ex) {
                throw Messages.MESSAGES.unableToLoadNSHandler(JBOSSWS_HANDLER_MAPPINGS_LOCATION, (Throwable)ex);
            }
        }
        return this.jbosswsHandlerMappings;
    }
}

