/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.extension.authserver.AuthServerDefinition;
import org.keycloak.subsystem.extension.authserver.AuthServerUtil;

public class ListOverlaysHandler
implements OperationStepHandler {
    static final String LIST_OVERLAYS_OPERATION = "list-overlays";
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-overlays", AuthServerDefinition.rscDescriptionResolver).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationStepHandler INSTANCE = new ListOverlaysHandler();

    private ListOverlaysHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        result.setEmptyList();
        String overlayName = AuthServerUtil.getOverlayName(operation);
        boolean isOverlayExists = AuthServerUtil.isOverlayExists(context, overlayName, PathAddress.EMPTY_ADDRESS);
        if (isOverlayExists) {
            TreeSet<String> overlays = new TreeSet<String>(this.getOverlayNames(context, overlayName));
            for (String key : overlays) {
                result.add(key);
            }
        }
        context.stepCompleted();
    }

    private Set<String> getOverlayNames(OperationContext context, String overlayName) {
        PathAddress overlayAddr = PathAddress.pathAddress((String)"deployment-overlay", (String)overlayName);
        Resource resource = context.readResourceFromRoot(overlayAddr);
        return resource.getChildrenNames("content");
    }
}

