/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServerConfig {
    static int clockTick;
    static final int DEFAULT_CLOCK_TICK = 10000;
    static final long DEFAULT_IDLE_INTERVAL = 30L;
    static final int DEFAULT_MAX_IDLE_CONNECTIONS = 200;
    static final long DEFAULT_MAX_REQ_TIME = -1L;
    static final long DEFAULT_MAX_RSP_TIME = -1L;
    static final long DEFAULT_TIMER_MILLIS = 1000L;
    static final long DEFAULT_DRAIN_AMOUNT = 65536L;
    final long idleInterval;
    final long drainAmount;
    final int maxIdleConnections;
    final long maxReqTime;
    final long maxRspTime;
    final long timerMillis;
    final boolean debug;

    public ServerConfig() {
        this(null);
    }

    public ServerConfig(Map<String, String> configuration) {
        this.idleInterval = this.getLongProperty(configuration, "sun.net.httpserver.idleInterval", 30L) * 1000L;
        clockTick = this.getIntegerProperty(configuration, "sun.net.httpserver.clockTick", 10000);
        this.maxIdleConnections = this.getIntegerProperty(configuration, "sun.net.httpserver.maxIdleConnections", 200);
        this.drainAmount = this.getLongProperty(configuration, "sun.net.httpserver.drainAmount", 65536L);
        this.maxReqTime = this.getLongProperty(configuration, "sun.net.httpserver.maxReqTime", -1L);
        this.maxRspTime = this.getLongProperty(configuration, "sun.net.httpserver.maxRspTime", -1L);
        this.timerMillis = this.getLongProperty(configuration, "sun.net.httpserver.timerMillis", 1000L);
        this.debug = this.getBooleanProperty(configuration, "sun.net.httpserver.debug");
    }

    void checkLegacyProperties(final Logger logger) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("sun.net.httpserver.readTimeout") != null) {
                    logger.warning("sun.net.httpserver.readTimeout property is no longer used. Use sun.net.httpserver.maxReqTime instead.");
                }
                if (System.getProperty("sun.net.httpserver.writeTimeout") != null) {
                    logger.warning("sun.net.httpserver.writeTimeout property is no longer used. Use sun.net.httpserver.maxRspTime instead.");
                }
                if (System.getProperty("sun.net.httpserver.selCacheTimeout") != null) {
                    logger.warning("sun.net.httpserver.selCacheTimeout property is no longer used.");
                }
                return null;
            }
        });
    }

    boolean debugEnabled() {
        return this.debug;
    }

    long getIdleInterval() {
        return this.idleInterval;
    }

    int getClockTick() {
        return clockTick;
    }

    int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    long getDrainAmount() {
        return this.drainAmount;
    }

    long getMaxReqTime() {
        return this.maxReqTime;
    }

    long getMaxRspTime() {
        return this.maxRspTime;
    }

    long getTimerMillis() {
        return this.timerMillis;
    }

    private long getLongProperty(Map<String, String> configuration, final String property, final long defaultVal) {
        if (configuration != null && configuration.containsKey(property)) {
            return Long.parseLong(configuration.get(property));
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong(property, defaultVal);
            }
        });
    }

    private int getIntegerProperty(Map<String, String> configuration, final String property, final int defaultVal) {
        if (configuration != null && configuration.containsKey(property)) {
            return Integer.parseInt(configuration.get(property));
        }
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(property, defaultVal);
            }
        });
    }

    private boolean getBooleanProperty(Map<String, String> configuration, final String property) {
        if (configuration != null && configuration.containsKey(property)) {
            return Boolean.parseBoolean(configuration.get(property));
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(property);
            }
        });
    }
}

