/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.security.AccessController;
import org.jboss.weld.security.GetBooleanSystemPropertyAction;

public final class SystemPropertiesConfiguration {
    public static final String DISABLE_XML_VALIDATION_KEY = "org.jboss.weld.xml.disableValidating";
    public static final String NON_PORTABLE_MODE_KEY = "org.jboss.weld.nonPortableMode";
    public static final SystemPropertiesConfiguration INSTANCE = new SystemPropertiesConfiguration();
    private boolean xmlValidationDisabled = this.initBooleanSystemProperty("org.jboss.weld.xml.disableValidating", false);
    private boolean nonPortableModeEnabled = this.initBooleanSystemProperty("org.jboss.weld.nonPortableMode", false);

    private SystemPropertiesConfiguration() {
    }

    public boolean isXmlValidationDisabled() {
        return this.xmlValidationDisabled;
    }

    public boolean isNonPortableModeEnabled() {
        return this.nonPortableModeEnabled;
    }

    private boolean initBooleanSystemProperty(String key, boolean defaultValue) {
        try {
            return AccessController.doPrivileged(new GetBooleanSystemPropertyAction(key));
        }
        catch (Throwable ignore) {
            return defaultValue;
        }
    }
}

