/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.File;
import org.jboss.as.repository.HashUtil;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.LocalDeploymentFileRepository;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LocalFileRepository
extends LocalDeploymentFileRepository
implements HostFileRepository,
Service<HostFileRepository> {
    private final File repositoryRoot;
    private final File configurationRoot;

    public LocalFileRepository(File repositoryRoot, File deploymentRoot, File configurationRoot) {
        super(deploymentRoot);
        this.repositoryRoot = repositoryRoot;
        this.configurationRoot = configurationRoot;
    }

    @Override
    public File getFile(String relativePath) {
        return new File(this.repositoryRoot, relativePath);
    }

    @Override
    public File getConfigurationFile(String relativePath) {
        return new File(this.configurationRoot, relativePath);
    }

    @Override
    public File[] getDeploymentFiles(byte[] hash) {
        return this.getDeploymentRoot(hash).listFiles();
    }

    @Override
    public File getDeploymentRoot(byte[] hash) {
        if (hash == null || hash.length == 0) {
            return this.deploymentRoot;
        }
        String hex = HashUtil.bytesToHexString(hash);
        File first = new File(this.deploymentRoot, hex.substring(0, 2));
        return new File(first, hex.substring(2));
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public HostFileRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

