/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.picketlink.idm;

import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.jboss.logging.Logger;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.event.CredentialUpdatedEvent;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.ContextualIdentityManager;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

public class KeycloakEventBridge
implements EventBridge {
    private static final Logger logger = Logger.getLogger(KeycloakEventBridge.class);
    private final boolean updateUserAccountAfterPasswordUpdate;

    public KeycloakEventBridge(boolean updateUserAccountAfterPasswordUpdate) {
        this.updateUserAccountAfterPasswordUpdate = updateUserAccountAfterPasswordUpdate;
        if (updateUserAccountAfterPasswordUpdate) {
            logger.info((Object)"userAccountControl attribute will be updated in Active Directory after user registration");
        }
    }

    public void raiseEvent(Object event) {
        if (this.updateUserAccountAfterPasswordUpdate && event instanceof CredentialUpdatedEvent) {
            CredentialUpdatedEvent credEvent = (CredentialUpdatedEvent)event;
            PartitionManager partitionManager = credEvent.getPartitionMananger();
            ContextualIdentityManager identityManager = (ContextualIdentityManager)partitionManager.createIdentityManager();
            IdentityContext identityCtx = identityManager.getIdentityContext();
            CredentialStore store = identityManager.getStoreSelector().getStoreForCredentialOperation(identityCtx, credEvent.getCredential().getClass());
            if (store instanceof LDAPIdentityStore) {
                LDAPIdentityStore ldapStore = (LDAPIdentityStore)store;
                LDAPOperationManager operationManager = ldapStore.getOperationManager();
                User picketlinkUser = (User)credEvent.getAccount();
                String userDN = ldapStore.getBindingDN((AttributedType)picketlinkUser, true);
                ModificationItem[] mods = new ModificationItem[1];
                BasicAttribute mod0 = new BasicAttribute("userAccountControl", "512");
                mods[0] = new ModificationItem(2, mod0);
                operationManager.modifyAttribute(userDN, (Attribute)mod0);
                logger.debug((Object)("Attribute userAccountControls switched to 512 after password update of user " + picketlinkUser.getLoginName()));
            } else {
                logger.debug((Object)"Store for credential updates is not LDAPIdentityStore. Ignored");
            }
        }
    }
}

