/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AddressClaimSet;
import org.keycloak.representations.IDToken;

public class AddressMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper {
    private static final List<ProtocolMapper.ConfigProperty> configProperties = new ArrayList<ProtocolMapper.ConfigProperty>();
    public static final String PROVIDER_ID = "oidc-address-mapper";

    public static ProtocolMapperModel createAddressMapper() {
        ProtocolMapperModel address = new ProtocolMapperModel();
        address.setName("address");
        address.setProtocolMapper(PROVIDER_ID);
        address.setProtocol("openid-connect");
        address.setConsentRequired(true);
        address.setConsentText("${address}");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        address.setConfig(config);
        return address;
    }

    public static ProtocolMapperModel createAddressMapper(boolean idToken, boolean accessToken) {
        ProtocolMapperModel address = new ProtocolMapperModel();
        address.setName("address");
        address.setProtocolMapper(PROVIDER_ID);
        address.setProtocol("openid-connect");
        address.setConsentRequired(true);
        address.setConsentText("${address}");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", Boolean.toString(idToken));
        config.put("id.token.claim", Boolean.toString(accessToken));
        address.setConfig(config);
        return address;
    }

    @Override
    public List<ProtocolMapper.ConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getDisplayType() {
        return "User Address";
    }

    @Override
    public String getDisplayCategory() {
        return "Token mapper";
    }

    @Override
    public String getHelpText() {
        return "Maps user address attributes (street, locality, region, postal_code, and country) to the OpenID Connect 'address' claim.";
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInAccessToken(mappingModel)) {
            return token;
        }
        this.setClaim((IDToken)token, userSession);
        return token;
    }

    @Override
    public IDToken transformIDToken(IDToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInIDToken(mappingModel)) {
            return token;
        }
        this.setClaim(token, userSession);
        return token;
    }

    protected void setClaim(IDToken token, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        AddressClaimSet addressSet = new AddressClaimSet();
        addressSet.setStreetAddress(user.getAttribute("street"));
        addressSet.setLocality(user.getAttribute("locality"));
        addressSet.setRegion(user.getAttribute("region"));
        addressSet.setPostalCode(user.getAttribute("postal_code"));
        addressSet.setCountry(user.getAttribute("country"));
        token.getOtherClaims().put("address", addressSet);
    }

    static {
        ProtocolMapper.ConfigProperty property = new ProtocolMapper.ConfigProperty();
        property.setName("id.token.claim");
        property.setLabel("Add to ID token");
        property.setType("boolean");
        property.setDefaultValue("true");
        property.setHelpText("Should the claim be added to the ID token?");
        configProperties.add(property);
        property = new ProtocolMapper.ConfigProperty();
        property.setName("access.token.claim");
        property.setLabel("Add to access token");
        property.setType("boolean");
        property.setDefaultValue("true");
        property.setHelpText("Should the claim be added to the access token?");
        configProperties.add(property);
    }
}

