/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.representations.IDToken;

public class OIDCAttributeMapperHelper {
    public static final String TOKEN_CLAIM_NAME = "claim.name";
    public static final String TOKEN_CLAIM_NAME_LABEL = "Token Claim Name";
    public static final String JSON_TYPE = "Claim JSON Type";
    public static final String INCLUDE_IN_ACCESS_TOKEN = "access.token.claim";
    public static final String INCLUDE_IN_ACCESS_TOKEN_LABEL = "Add to access token";
    public static final String INCLUDE_IN_ACCESS_TOKEN_HELP_TEXT = "Should the claim be added to the access token?";
    public static final String INCLUDE_IN_ID_TOKEN = "id.token.claim";
    public static final String INCLUDE_IN_ID_TOKEN_LABEL = "Add to ID token";
    public static final String INCLUDE_IN_ID_TOKEN_HELP_TEXT = "Should the claim be added to the ID token?";

    public static Object mapAttributeValue(ProtocolMapperModel mappingModel, Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        String type = (String)mappingModel.getConfig().get(JSON_TYPE);
        if (type == null) {
            return attributeValue;
        }
        if (type.equals("boolean")) {
            if (attributeValue instanceof Boolean) {
                return attributeValue;
            }
            if (attributeValue instanceof String) {
                return Boolean.valueOf((String)attributeValue);
            }
            throw new RuntimeException("cannot map type for token claim");
        }
        if (type.equals("String")) {
            if (attributeValue instanceof String) {
                return attributeValue;
            }
            return attributeValue.toString();
        }
        if (type.equals("long")) {
            if (attributeValue instanceof Long) {
                return attributeValue;
            }
            if (attributeValue instanceof String) {
                return Long.valueOf((String)attributeValue);
            }
            throw new RuntimeException("cannot map type for token claim");
        }
        if (type.equals("int")) {
            if (attributeValue instanceof Integer) {
                return attributeValue;
            }
            if (attributeValue instanceof String) {
                return Integer.valueOf((String)attributeValue);
            }
            throw new RuntimeException("cannot map type for token claim");
        }
        return attributeValue;
    }

    public static void mapClaim(IDToken token, ProtocolMapperModel mappingModel, Object attributeValue) {
        if (attributeValue == null) {
            return;
        }
        attributeValue = OIDCAttributeMapperHelper.mapAttributeValue(mappingModel, attributeValue);
        String protocolClaim = (String)mappingModel.getConfig().get(TOKEN_CLAIM_NAME);
        String[] split = protocolClaim.split("\\.");
        HashMap<String, Object> jsonObject = token.getOtherClaims();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                jsonObject.put(split[i], attributeValue);
                continue;
            }
            HashMap<String, Object> nested = (HashMap<String, Object>)jsonObject.get(split[i]);
            if (nested != null) continue;
            nested = new HashMap<String, Object>();
            jsonObject.put(split[i], nested);
            jsonObject = nested;
        }
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean consentRequired, String consentText, boolean accessToken, boolean idToken, String mapperId) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(mapperId);
        mapper.setProtocol("openid-connect");
        mapper.setConsentRequired(consentRequired);
        mapper.setConsentText(consentText);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("user.attribute", userAttribute);
        config.put(TOKEN_CLAIM_NAME, tokenClaimName);
        config.put(JSON_TYPE, claimType);
        if (accessToken) {
            config.put(INCLUDE_IN_ACCESS_TOKEN, "true");
        }
        if (idToken) {
            config.put(INCLUDE_IN_ID_TOKEN, "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    public static boolean includeInIDToken(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get(INCLUDE_IN_ID_TOKEN));
    }

    public static boolean includeInAccessToken(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get(INCLUDE_IN_ACCESS_TOKEN));
    }

    public static void addAttributeConfig(List<ProtocolMapper.ConfigProperty> configProperties) {
        ProtocolMapper.ConfigProperty property = new ProtocolMapper.ConfigProperty();
        property.setName(TOKEN_CLAIM_NAME);
        property.setLabel(TOKEN_CLAIM_NAME_LABEL);
        property.setType("String");
        property.setHelpText("Name of the claim to insert into the token.  This can be a fully qualified name like 'address.street'.  In this case, a nested json object will be created.");
        configProperties.add(property);
        property = new ProtocolMapper.ConfigProperty();
        property.setName(JSON_TYPE);
        property.setLabel(JSON_TYPE);
        ArrayList<String> types = new ArrayList<String>(3);
        types.add("String");
        types.add("long");
        types.add("int");
        types.add("boolean");
        property.setType("List");
        property.setDefaultValue(types);
        property.setHelpText("JSON type that should be used to populate the json claim in the token.  long, int, boolean, and String are valid values.");
        configProperties.add(property);
        property = new ProtocolMapper.ConfigProperty();
        property.setName(INCLUDE_IN_ID_TOKEN);
        property.setLabel(INCLUDE_IN_ID_TOKEN_LABEL);
        property.setType("boolean");
        property.setDefaultValue("true");
        property.setHelpText(INCLUDE_IN_ID_TOKEN_HELP_TEXT);
        configProperties.add(property);
        property = new ProtocolMapper.ConfigProperty();
        property.setName(INCLUDE_IN_ACCESS_TOKEN);
        property.setLabel(INCLUDE_IN_ACCESS_TOKEN_LABEL);
        property.setType("boolean");
        property.setDefaultValue("true");
        property.setHelpText(INCLUDE_IN_ACCESS_TOKEN_HELP_TEXT);
        configProperties.add(property);
    }
}

