/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.models.ClientIdentityProviderMappingModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.social.SocialIdentityProvider;

public class IdentityProviderResource {
    private static Logger logger = Logger.getLogger(IdentityProviderResource.class);
    private final RealmAuth auth;
    private final RealmModel realm;
    private final KeycloakSession session;
    private final IdentityProviderModel identityProviderModel;

    public IdentityProviderResource(RealmAuth auth, RealmModel realm, KeycloakSession session, IdentityProviderModel identityProviderModel) {
        this.realm = realm;
        this.session = session;
        this.identityProviderModel = identityProviderModel;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public IdentityProviderRepresentation getIdentityProvider() {
        IdentityProviderRepresentation rep = ModelToRepresentation.toRepresentation((IdentityProviderModel)this.identityProviderModel);
        return rep;
    }

    @DELETE
    @NoCache
    public Response delete() {
        this.auth.requireManage();
        this.removeClientIdentityProviders(this.realm.getApplications(), this.identityProviderModel);
        this.removeClientIdentityProviders(this.realm.getOAuthClients(), this.identityProviderModel);
        this.realm.removeIdentityProviderByAlias(this.identityProviderModel.getAlias());
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(IdentityProviderRepresentation providerRep) {
        try {
            this.auth.requireManage();
            String internalId = providerRep.getInternalId();
            String newProviderId = providerRep.getAlias();
            String oldProviderId = this.getProviderIdByInternalId(this.realm, internalId);
            this.realm.updateIdentityProvider(RepresentationToModel.toModel((IdentityProviderRepresentation)providerRep));
            if (oldProviderId != null && !oldProviderId.equals(newProviderId)) {
                logger.debug((Object)("Changing providerId in all clients and linked users. oldProviderId=" + oldProviderId + ", newProviderId=" + newProviderId));
                this.updateClientsAfterProviderAliasChange(this.realm.getApplications(), oldProviderId, newProviderId);
                this.updateClientsAfterProviderAliasChange(this.realm.getOAuthClients(), oldProviderId, newProviderId);
                this.updateUsersAfterProviderAliasChange(this.session.users().getUsers(this.realm), oldProviderId, newProviderId);
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Identity Provider " + providerRep.getAlias() + " already exists");
        }
    }

    private String getProviderIdByInternalId(RealmModel realm, String providerInternalId) {
        List providerModels = realm.getIdentityProviders();
        for (IdentityProviderModel providerModel : providerModels) {
            if (!providerModel.getInternalId().equals(providerInternalId)) continue;
            return providerModel.getAlias();
        }
        return null;
    }

    private void updateClientsAfterProviderAliasChange(List<? extends ClientModel> clients, String oldProviderId, String newProviderId) {
        for (ClientModel clientModel : clients) {
            List clientIdentityProviders = clientModel.getIdentityProviders();
            boolean found = true;
            for (ClientIdentityProviderMappingModel mappingModel : clientIdentityProviders) {
                if (!mappingModel.getIdentityProvider().equals(oldProviderId)) continue;
                mappingModel.setIdentityProvider(newProviderId);
                found = true;
                break;
            }
            if (!found) continue;
            clientModel.updateIdentityProviders(clientIdentityProviders);
        }
    }

    private void updateUsersAfterProviderAliasChange(List<UserModel> users, String oldProviderId, String newProviderId) {
        for (UserModel user : users) {
            FederatedIdentityModel federatedIdentity = this.session.users().getFederatedIdentity(user, oldProviderId, this.realm);
            if (federatedIdentity == null) continue;
            this.session.users().removeFederatedIdentity(this.realm, user, oldProviderId);
            FederatedIdentityModel newFederatedIdentity = new FederatedIdentityModel(newProviderId, federatedIdentity.getUserId(), federatedIdentity.getUserName(), federatedIdentity.getToken());
            this.session.users().addFederatedIdentity(this.realm, user, newFederatedIdentity);
        }
    }

    private IdentityProviderFactory getIdentityProviderFactory() {
        ArrayList allProviders = new ArrayList();
        allProviders.addAll(this.session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        for (ProviderFactory providerFactory : allProviders) {
            if (!providerFactory.getId().equals(this.identityProviderModel.getProviderId())) continue;
            return (IdentityProviderFactory)providerFactory;
        }
        return null;
    }

    @GET
    @Path(value="export")
    public Response export(@Context UriInfo uriInfo, @QueryParam(value="format") String format) {
        try {
            this.auth.requireView();
            IdentityProviderFactory factory = this.getIdentityProviderFactory();
            return factory.create(this.identityProviderModel).export(uriInfo, this.realm, format);
        }
        catch (Exception e) {
            return Flows.errors().error("Could not export public broker configuration for identity provider [" + this.identityProviderModel.getProviderId() + "].", Response.Status.NOT_FOUND);
        }
    }

    private void removeClientIdentityProviders(List<? extends ClientModel> clients, IdentityProviderModel identityProvider) {
        block0: for (ClientModel clientModel : clients) {
            List identityProviders = clientModel.getIdentityProviders();
            for (ClientIdentityProviderMappingModel providerMappingModel : new ArrayList(identityProviders)) {
                if (!providerMappingModel.getIdentityProvider().equals(identityProvider.getAlias())) continue;
                identityProviders.remove(providerMappingModel);
                clientModel.updateIdentityProviders(identityProviders);
                continue block0;
            }
        }
    }
}

