/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.util.JsonSerialization;

public class RealmsAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmsAdminResource.class);
    protected AdminAuth auth;
    protected TokenManager tokenManager;
    @Context
    protected KeycloakSession session;
    @Context
    protected KeycloakApplication keycloak;
    public static final CacheControl noCache = new CacheControl();

    public RealmsAdminResource(AdminAuth auth, TokenManager tokenManager) {
        this.auth = auth;
        this.tokenManager = tokenManager;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RealmRepresentation> getRealms() {
        RealmManager realmManager = new RealmManager(this.session);
        ArrayList<RealmRepresentation> reps = new ArrayList<RealmRepresentation>();
        if (this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm())) {
            List realms = this.session.realms().getRealms();
            for (RealmModel realm : realms) {
                this.addRealmRep(reps, realm, realm.getMasterAdminApp());
            }
        } else {
            ApplicationModel adminApp = this.auth.getRealm().getApplicationByName(realmManager.getRealmAdminApplicationName(this.auth.getRealm()));
            this.addRealmRep(reps, this.auth.getRealm(), adminApp);
        }
        logger.debug((Object)"getRealms()");
        return reps;
    }

    protected void addRealmRep(List<RealmRepresentation> reps, RealmModel realm, ApplicationModel realmManagementApplication) {
        if (this.auth.hasAppRole(realmManagementApplication, AdminRoles.MANAGE_REALM)) {
            reps.add(ModelToRepresentation.toRepresentation((RealmModel)realm, (boolean)false));
        } else if (this.auth.hasOneOfAppRole(realmManagementApplication, AdminRoles.ALL_REALM_ROLES)) {
            RealmRepresentation rep = new RealmRepresentation();
            rep.setRealm(realm.getName());
            reps.add(rep);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response importRealm(@Context UriInfo uriInfo, RealmRepresentation rep) {
        RealmManager realmManager = new RealmManager(this.session);
        realmManager.setContextPath(this.keycloak.getContextPath());
        if (!this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm())) {
            throw new ForbiddenException();
        }
        if (!this.auth.hasRealmRole(AdminRoles.CREATE_REALM)) {
            throw new ForbiddenException();
        }
        logger.debugv("importRealm: {0}", (Object)rep.getRealm());
        try {
            RealmModel realm = realmManager.importRealm(rep);
            this.grantPermissionsToRealmCreator(realm);
            URI location = AdminRoot.realmsUrl(uriInfo).path(realm.getName()).build(new Object[0]);
            logger.debugv("imported realm success, sending back: {0}", (Object)location.toString());
            return Response.created((URI)location).build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Realm " + rep.getRealm() + " already exists");
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response uploadRealm(@Context UriInfo uriInfo, MultipartFormDataInput input) throws IOException {
        RealmManager realmManager = new RealmManager(this.session);
        realmManager.setContextPath(this.keycloak.getContextPath());
        if (!this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm())) {
            throw new ForbiddenException();
        }
        if (!this.auth.hasRealmRole(AdminRoles.CREATE_REALM)) {
            throw new ForbiddenException();
        }
        Map uploadForm = input.getFormDataMap();
        List inputParts = (List)uploadForm.get("file");
        for (InputPart inputPart : inputParts) {
            RealmModel realm;
            RealmRepresentation rep = (RealmRepresentation)JsonSerialization.readValue((String)inputPart.getBodyAsString(), RealmRepresentation.class);
            try {
                realm = realmManager.importRealm(rep);
            }
            catch (ModelDuplicateException e) {
                return Flows.errors().exists("Realm " + rep.getRealm() + " already exists");
            }
            this.grantPermissionsToRealmCreator(realm);
            if (inputParts.size() != 1) continue;
            URI location = AdminRoot.realmsUrl(uriInfo).path(realm.getName()).build(new Object[0]);
            return Response.created((URI)location).build();
        }
        return Response.noContent().build();
    }

    private void grantPermissionsToRealmCreator(RealmModel realm) {
        if (this.auth.hasRealmRole(AdminRoles.ADMIN)) {
            return;
        }
        RealmModel adminRealm = new RealmManager(this.session).getKeycloakAdminstrationRealm();
        ApplicationModel realmAdminApp = realm.getMasterAdminApp();
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.getRole(r);
            this.auth.getUser().grantRole(role);
        }
    }

    @Path(value="{realm}")
    public RealmAdminResource getRealmAdmin(@Context HttpHeaders headers, @PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("{realm} = " + name);
        }
        if (!this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm()) && !this.auth.getRealm().equals(realm)) {
            throw new ForbiddenException();
        }
        RealmAuth realmAuth = this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm()) ? new RealmAuth(this.auth, realm.getMasterAdminApp()) : new RealmAuth(this.auth, realm.getApplicationByName(realmManager.getRealmAdminApplicationName(this.auth.getRealm())));
        RealmAdminResource adminResource = new RealmAdminResource(realmAuth, realm, this.tokenManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)adminResource);
        return adminResource;
    }

    static {
        noCache.setNoCache(true);
    }
}

