/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.Loggers;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;

public class PortComponentMetaData {
    public static final String PARAMETER_WEBSERVICE_ID = "webserviceID";
    private volatile WebserviceDescriptionMetaData webserviceDescription;
    private final String portComponentName;
    private volatile QName wsdlPort;
    private final String serviceEndpointInterface;
    private final String ejbLink;
    private final String servletLink;
    private final List<UnifiedHandlerMetaData> handlers;
    private final String contextRoot;
    private final boolean addressingEnabled;
    private final boolean addressingRequired;
    private final String addressingResponses;
    private final boolean mtomEnabled;
    private final int mtomThreshold;
    private final boolean respectBindingEnabled;
    private final QName wsdlService;
    private final String protocolBinding;
    private final UnifiedHandlerChainsMetaData handlerChains;

    public PortComponentMetaData(String portComponentName, QName wsdlPort, String serviceEndpointInterface, String ejbLink, String servletLink, List<UnifiedHandlerMetaData> handlers, String contextRoot, boolean addressingEnabled, boolean addressingRequired, String addressingResponses, boolean mtomEnabled, int mtomThreshold, boolean respectBindingEnabled, QName wsdlService, String protocolBinding, UnifiedHandlerChainsMetaData handlerChains) {
        this.portComponentName = portComponentName;
        if (wsdlPort.getNamespaceURI().length() == 0) {
            Loggers.METADATA_LOGGER.webservicesXmlElementNotNamespaceQualified(wsdlPort);
        }
        this.wsdlPort = wsdlPort;
        this.serviceEndpointInterface = serviceEndpointInterface;
        this.ejbLink = ejbLink;
        this.servletLink = servletLink;
        this.handlers = handlers != null && !handlers.isEmpty() ? Collections.unmodifiableList(handlers) : Collections.emptyList();
        this.contextRoot = contextRoot;
        this.addressingEnabled = addressingEnabled;
        this.addressingRequired = addressingRequired;
        if (!("ANONYMOUS".equals(addressingResponses) || "NON_ANONYMOUS".equals(addressingResponses) || "ALL".equals(addressingResponses))) {
            throw Messages.MESSAGES.unsupportedAddressingResponseType(addressingResponses);
        }
        this.addressingResponses = addressingResponses;
        this.mtomEnabled = mtomEnabled;
        this.mtomThreshold = mtomThreshold;
        this.respectBindingEnabled = respectBindingEnabled;
        this.wsdlService = wsdlService;
        this.protocolBinding = protocolBinding;
        this.handlerChains = handlerChains;
    }

    public PortComponentMetaData(String portComponentName, QName wsdlPort, String serviceEndpointInterface, String ejbLink, String servletLink, List<UnifiedHandlerMetaData> handlers, String contextRoot, QName wsdlService, String protocolBinding, UnifiedHandlerChainsMetaData handlerChains) {
        this(portComponentName, wsdlPort, serviceEndpointInterface, ejbLink, servletLink, handlers, contextRoot, false, false, "ALL", false, 0, false, wsdlService, protocolBinding, handlerChains);
    }

    public WebserviceDescriptionMetaData getWebserviceDescription() {
        return this.webserviceDescription;
    }

    protected void setWebserviceDescription(WebserviceDescriptionMetaData webserviceDescription) {
        this.webserviceDescription = webserviceDescription;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    @Deprecated
    public void setWsdlPort(QName wsdlPort) {
        this.wsdlPort = wsdlPort;
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public String getServletLink() {
        return this.servletLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void addHandler(UnifiedHandlerMetaData handler) {
        this.handlers.add(handler);
    }

    public UnifiedHandlerMetaData[] getHandlers() {
        UnifiedHandlerMetaData[] array = new UnifiedHandlerMetaData[this.handlers.size()];
        this.handlers.toArray(array);
        return array;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public String serialize() {
        QName wsdlPort = this.getWsdlPort();
        StringBuilder builder = new StringBuilder("<port-component>");
        builder.append("<port-component-name>").append(this.portComponentName).append("</port-component-name>");
        builder.append("<wsdl-port xmlns:").append(wsdlPort.getPrefix()).append("='").append(wsdlPort.getNamespaceURI()).append("'>");
        builder.append(wsdlPort.getPrefix()).append(':').append(wsdlPort.getLocalPart()).append("</wsdl-port>");
        builder.append("<service-endpoint-interface>").append(this.serviceEndpointInterface).append("</service-endpoint-interface>");
        builder.append("<service-impl-bean>");
        if (this.ejbLink != null) {
            builder.append("<ejb-link>" + this.ejbLink + "</ejb-link>");
        } else {
            builder.append("<servlet-link>" + this.servletLink + "</servlet-link>");
        }
        builder.append("</service-impl-bean>");
        builder.append("</port-component>");
        return builder.toString();
    }
}

