/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition.resources.arjuna;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerNestedAction;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.omg.CosTransactions.Status;

public class ServerResource {
    protected ServerControl _theControl;
    protected final List<ServerNestedAction> _children = Collections.synchronizedList(new LinkedList());
    protected Uid _theUid;
    protected ServerResource _parent;
    protected boolean _valid;
    protected boolean _destroyed;

    public void finalize() throws Throwable {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerResource.finalize ( " + this._theUid + " )"));
        }
        this.tidyup();
        super.finalize();
    }

    public boolean interposeResource() {
        return true;
    }

    public final boolean valid() {
        return this._valid;
    }

    public final synchronized boolean destroyed() {
        return this._destroyed;
    }

    public final ServerControl control() {
        return this._theControl;
    }

    public final boolean addChild(ServerNestedAction c) {
        if (this._children.add(c)) {
            c.setParentHandle(this);
            return true;
        }
        return false;
    }

    public final boolean removeChild(ServerNestedAction c) {
        c.setParentHandle(null);
        return this._children.remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerNestedAction getChild(Uid actUid) {
        List<ServerNestedAction> list2 = this._children;
        synchronized (list2) {
            for (ServerNestedAction action : this._children) {
                if (!actUid.equals(action.get_uid())) continue;
                return action;
            }
        }
        return null;
    }

    public final List<ServerNestedAction> getChildren() {
        return this._children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean abortChild(ServerNestedAction toAbort) {
        if (toAbort != null) {
            ServerNestedAction child;
            List<ServerNestedAction> list2 = this._children;
            synchronized (list2) {
                child = this.getChild(toAbort.get_uid());
                if (child != null) {
                    this._children.remove(child);
                }
            }
            if (child != null) {
                Status nestedStatus = child.otsStatus();
                if (nestedStatus != Status.StatusRolledBack && nestedStatus != Status.StatusCommitted && nestedStatus != Status.StatusNoTransaction) {
                    child.rollback_subtransaction();
                }
                try {
                    ORBManager.getPOA().shutdownObject(child.theResource());
                }
                catch (Exception e) {
                    // empty catch block
                }
                return true;
            }
            jtsLogger.i18NLogger.warn_interposition_resources_arjuna_notchild("ServerResource.abortChild");
        } else {
            jtsLogger.i18NLogger.warn_interposition_resources_arjuna_nochild("ServerResource.abortChild");
        }
        return false;
    }

    public final synchronized void setParentHandle(ServerResource p) {
        this._parent = p;
    }

    public final synchronized ServerResource getParentHandle() {
        return this._parent;
    }

    public Uid get_uid() {
        return this._theUid;
    }

    public final Status otsStatus() {
        try {
            if (this._theControl != null) {
                return this._theControl.getImplHandle().get_status();
            }
            return Status.StatusNoTransaction;
        }
        catch (Exception e) {
            return Status.StatusUnknown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getChildren(int depth) {
        String children = "";
        List<ServerNestedAction> list2 = this._children;
        synchronized (list2) {
            for (ServerNestedAction child : this._children) {
                children = children + "\n";
                for (int i = 0; i < depth; ++i) {
                    children = children + " ";
                }
                children = children + child.get_uid();
                children = children + child.getChildren(depth + 1);
            }
        }
        return children;
    }

    protected ServerResource() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ServerResource::ServerResource ()");
        }
        this._theControl = null;
        this._parent = null;
        this._valid = true;
        this._destroyed = false;
    }

    protected ServerResource(ServerControl control) {
        this._theControl = control;
        this._theUid = control.get_uid();
        this._parent = null;
        this._valid = true;
        this._destroyed = false;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerResource::ServerResource ( " + this._theUid + " )"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void tidyup() {
        List<ServerNestedAction> list2 = this._children;
        // MONITORENTER : list2
        while (this._children.size() > 0) {
            ServerNestedAction child = this._children.remove(0);
            child.setParentHandle(null);
            try {
                ORBManager.getPOA().shutdownObject(child.theResource());
            }
            catch (Exception exception) {}
        }
        // MONITOREXIT : list2
        if (this._theControl == null) return;
        if (this._theControl.isWrapper()) {
            try {
                this._theControl.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._theControl = null;
    }
}

