/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class TimerCMTTxInterceptor
extends CMTTxInterceptor {
    private static final ThreadLocal<Throwable> EXCEPTION = new ThreadLocal();
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new TimerCMTTxInterceptor());

    @Override
    public void handleExceptionInOurTx(InterceptorContext invocation, Throwable t, Transaction tx, EJBComponent component) throws Exception {
        EXCEPTION.set(t);
        super.handleExceptionInOurTx(invocation, t, tx, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endTransaction(TransactionManager tm, Transaction tx) {
        try {
            boolean rolledBack = false;
            try {
                if (tx.getStatus() == 1) {
                    rolledBack = true;
                }
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            finally {
                super.endTransaction(tm, tx);
            }
            if (rolledBack && EXCEPTION.get() == null) {
                throw EjbMessages.MESSAGES.timerInvocationRolledBack();
            }
        }
        finally {
            EXCEPTION.remove();
        }
    }
}

