/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.tomcat.AbstractKeycloakAuthenticatorValve;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;

public class CatalinaSessionTokenStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger("" + CatalinaSessionTokenStore.class);
    private Request request;
    private KeycloakDeployment deployment;
    private CatalinaUserSessionManagement sessionManagement;
    protected GenericPrincipalFactory principalFactory;
    protected AbstractKeycloakAuthenticatorValve valve;

    public CatalinaSessionTokenStore(Request request, KeycloakDeployment deployment, CatalinaUserSessionManagement sessionManagement, GenericPrincipalFactory principalFactory, AbstractKeycloakAuthenticatorValve valve) {
        this.request = request;
        this.deployment = deployment;
        this.sessionManagement = sessionManagement;
        this.principalFactory = principalFactory;
        this.valve = valve;
    }

    public void checkCurrentToken() {
        Session catalinaSession = this.request.getSessionInternal(false);
        if (catalinaSession == null) {
            return;
        }
        SerializableKeycloakAccount account = (SerializableKeycloakAccount)catalinaSession.getSession().getAttribute(SerializableKeycloakAccount.class.getName());
        if (account == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = account.getKeycloakSecurityContext();
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        }
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return;
        }
        log.fine("Cleanup and expire session " + catalinaSession.getId() + " after failed refresh");
        this.request.setUserPrincipal(null);
        this.request.setAuthType(null);
        this.cleanSession(catalinaSession);
        catalinaSession.expire();
    }

    protected void cleanSession(Session catalinaSession) {
        catalinaSession.getSession().removeAttribute(KeycloakAccount.class.getName());
        catalinaSession.setPrincipal(null);
        catalinaSession.setAuthType(null);
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        Session session = this.request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SerializableKeycloakAccount account = (SerializableKeycloakAccount)session.getSession().getAttribute(SerializableKeycloakAccount.class.getName());
        if (account == null) {
            return false;
        }
        log.fine("remote logged in already. Establish state from session");
        RefreshableKeycloakSecurityContext securityContext = account.getKeycloakSecurityContext();
        if (!this.deployment.getRealm().equals(securityContext.getRealm())) {
            log.fine("Account from cookie is from a different realm than for the request.");
            this.cleanSession(session);
            return false;
        }
        securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), account.getPrincipal(), account.getRoles(), (KeycloakSecurityContext)securityContext);
            session.setPrincipal((Principal)principal);
            session.setAuthType("KEYCLOAK");
        }
        this.request.setUserPrincipal((Principal)principal);
        this.request.setAuthType("KEYCLOAK");
        this.restoreRequest();
        return true;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        Set roles = account.getRoles();
        GenericPrincipal principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), account.getPrincipal(), roles, (KeycloakSecurityContext)securityContext);
        SerializableKeycloakAccount sAccount = new SerializableKeycloakAccount(roles, account.getPrincipal(), securityContext);
        Session session = this.request.getSessionInternal(true);
        session.setPrincipal((Principal)principal);
        session.setAuthType("KEYCLOAK");
        session.getSession().setAttribute(SerializableKeycloakAccount.class.getName(), (Object)sAccount);
        String username = securityContext.getToken().getSubject();
        log.fine("userSessionManagement.login: " + username);
        this.sessionManagement.login(session);
    }

    public void logout() {
        Session session = this.request.getSessionInternal(false);
        if (session != null) {
            this.cleanSession(session);
        }
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }

    public void saveRequest() {
        try {
            this.valve.keycloakSaveRequest(this.request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean restoreRequest() {
        return this.valve.keycloakRestoreRequest(this.request);
    }

    public static class SerializableKeycloakAccount
    implements KeycloakAccount,
    Serializable {
        protected Set<String> roles;
        protected Principal principal;
        protected RefreshableKeycloakSecurityContext securityContext;

        public SerializableKeycloakAccount(Set<String> roles, Principal principal, RefreshableKeycloakSecurityContext securityContext) {
            this.roles = roles;
            this.principal = principal;
            this.securityContext = securityContext;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
            return this.securityContext;
        }
    }
}

