/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.jboss.ws.api.configuration.ClientConfigurer;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.configuration.ConfigDelegateHandler;
import org.jboss.ws.common.configuration.LogicalConfigDelegateHandler;
import org.jboss.ws.common.configuration.SOAPConfigDelegateHandler;
import org.jboss.ws.common.configuration.SecurityActions;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class ConfigHelper
implements ClientConfigurer {
    private static Map<String, String> bindingIDs = new HashMap<String, String>(8);

    public void setConfigHandlers(BindingProvider port, String configFile, String configName) {
        ClientConfig config = this.readConfig(configFile, configName);
        this.setupConfigHandlers(port.getBinding(), (CommonConfig)config);
    }

    public void setConfigProperties(Object client, String configFile, String configName) {
        throw Messages.MESSAGES.operationNotSupportedBy("setConfigProperties", this.getClass());
    }

    protected ClientConfig readConfig(String configFile, String configName) {
        block16: {
            ClientConfig cf;
            if (configFile != null) {
                InputStream is = null;
                try {
                    is = SecurityActions.getContextClassLoader().getResourceAsStream(configFile);
                    if (is != null) {
                        ClientConfig cc;
                        ConfigRoot config = ConfigMetaDataParser.parse((InputStream)is);
                        ClientConfig clientConfig = cc = config != null ? config.getClientConfigByName(configName) : null;
                        if (cc != null) {
                            ClientConfig clientConfig2 = cc;
                            return clientConfig2;
                        }
                    }
                    break block16;
                }
                catch (Exception e) {
                    throw Messages.MESSAGES.couldNotReadConfiguration(configFile, e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            ServerConfig sc = ConfigHelper.getServerConfig();
            if (sc != null && (cf = sc.getClientConfig(configName)) != null) {
                return cf;
            }
        }
        throw Messages.MESSAGES.configurationNotFound(configName);
    }

    public void setupConfigHandlers(Binding binding, CommonConfig config) {
        if (config != null) {
            List<Handler> userHandlers = ConfigHelper.getNonConfigHandlers(binding.getHandlerChain());
            List<Handler> handlers = ConfigHelper.convertToHandlers(config.getPreHandlerChains(), binding.getBindingID(), true);
            handlers.addAll(userHandlers);
            handlers.addAll(ConfigHelper.convertToHandlers(config.getPostHandlerChains(), binding.getBindingID(), false));
            binding.setHandlerChain(handlers);
        }
    }

    private static List<Handler> getNonConfigHandlers(List<Handler> handlerChain) {
        LinkedList<Handler> list = new LinkedList<Handler>();
        for (Handler h : handlerChain) {
            if (h instanceof ConfigDelegateHandler) continue;
            list.add(h);
        }
        return list;
    }

    private static List<Handler> convertToHandlers(List<UnifiedHandlerChainMetaData> handlerChains, String bindingID, boolean isPre) {
        LinkedList<Handler> handlers = new LinkedList<Handler>();
        if (handlerChains != null && !handlerChains.isEmpty()) {
            String protocolBinding = bindingIDs.get(bindingID);
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (handlerChain.getPortNamePattern() != null || handlerChain.getServiceNamePattern() != null) {
                    Loggers.ROOT_LOGGER.filtersNotSupported();
                }
                if (!ConfigHelper.matchProtocolBinding(protocolBinding, handlerChain.getProtocolBindings())) continue;
                for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                    Object h;
                    if (uhmd.getInitParams() != null && !uhmd.getInitParams().isEmpty()) {
                        Loggers.ROOT_LOGGER.initParamsNotSupported();
                    }
                    if ((h = ConfigHelper.newInstance(uhmd.getHandlerClass())) == null) continue;
                    if (h instanceof Handler) {
                        if (h instanceof LogicalHandler) {
                            handlers.add(new LogicalConfigDelegateHandler((LogicalHandler)h, isPre));
                            continue;
                        }
                        if (h instanceof SOAPHandler) {
                            handlers.add(new SOAPConfigDelegateHandler((SOAPHandler)h, isPre));
                            continue;
                        }
                        handlers.add(new ConfigDelegateHandler((Handler)h, isPre));
                        continue;
                    }
                    throw Messages.MESSAGES.notJAXWSHandler(uhmd.getHandlerClass());
                }
            }
        }
        return handlers;
    }

    private static boolean matchProtocolBinding(String currentProtocolBinding, String handlerChainProtocolBindings) {
        if (handlerChainProtocolBindings == null) {
            return true;
        }
        LinkedList<String> protocolBindings = new LinkedList<String>();
        if (handlerChainProtocolBindings != null) {
            StringTokenizer st = new StringTokenizer(handlerChainProtocolBindings, " ", false);
            while (st.hasMoreTokens()) {
                protocolBindings.add(st.nextToken());
            }
        }
        return protocolBindings.contains(currentProtocolBinding);
    }

    private static Object newInstance(String className) {
        try {
            DelegateClassLoader loader = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), SecurityActions.getContextClassLoader());
            Class<?> clazz = SecurityActions.loadClass(loader, className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            Loggers.ROOT_LOGGER.cannotAddHandler(className, e);
            return null;
        }
    }

    private static ServerConfig getServerConfig() {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        ServerConfigFactory scf = (ServerConfigFactory)SPIProvider.getInstance().getSPI(ServerConfigFactory.class, cl);
        return scf != null ? scf.getServerConfig() : null;
    }

    static {
        bindingIDs.put("http://schemas.xmlsoap.org/wsdl/soap/http", "##SOAP11_HTTP");
        bindingIDs.put("http://www.w3.org/2003/05/soap/bindings/HTTP/", "##SOAP12_HTTP");
        bindingIDs.put("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", "##SOAP11_HTTP_MTOM");
        bindingIDs.put("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", "##SOAP12_HTTP_MTOM");
        bindingIDs.put("http://www.w3.org/2004/08/wsdl/http", "##XML_HTTP");
    }
}

