/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.security.AccessController;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;

public class EndpointAddressDeploymentAspect
extends AbstractDeploymentAspect {
    @Override
    public void start(Deployment dep) {
        Service service = dep.getService();
        String contextRoot = service.getContextRoot();
        if (contextRoot == null) {
            throw Messages.MESSAGES.cannotObtainContextRoot(dep.getSimpleName());
        }
        PortValue port = new PortValue((Integer)service.getProperty("port"), null);
        ServerConfig serverConfig = EndpointAddressDeploymentAspect.getServerConfig();
        port.setServerConfig(serverConfig);
        String host = serverConfig.getWebServiceHost();
        HashMap<String, HttpEndpoint> endpointsMap = new HashMap<String, HttpEndpoint>();
        LinkedList<HttpEndpoint> deleteList = new LinkedList<HttpEndpoint>();
        for (Endpoint endpoint : service.getEndpoints()) {
            if (!(endpoint instanceof HttpEndpoint)) continue;
            boolean confidential = this.isConfidentialTransportGuarantee(dep, endpoint);
            int currentPort = port.getValue(confidential);
            String hostAndPort = host + (currentPort > 0 ? ":" + currentPort : "");
            HttpEndpoint httpEp = (HttpEndpoint)endpoint;
            String urlPattern = httpEp.getURLPattern();
            if (urlPattern == null) {
                throw Messages.MESSAGES.cannotObtainUrlPattern(endpoint.getName());
            }
            if (urlPattern.endsWith("/*")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
            }
            String protocol = confidential ? "https://" : "http://";
            String address = protocol + hostAndPort + (contextRoot.equals("/") && urlPattern.startsWith("/") ? "" : contextRoot) + urlPattern;
            httpEp.setAddress(address);
            if (!endpointsMap.containsKey(address)) {
                endpointsMap.put(address, httpEp);
                continue;
            }
            deleteList.add(httpEp);
        }
        for (Endpoint endpoint : deleteList) {
            service.getEndpoints().remove(endpoint);
        }
    }

    private static ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }

    protected boolean isConfidentialTransportGuarantee(Deployment dep, Endpoint ep) {
        if (WSHelper.isJaxrpcDeployment(dep)) {
            return false;
        }
        String transportGuarantee = null;
        if (WSHelper.isJaxwsJseEndpoint(ep)) {
            JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
            if (webMetaData != null) {
                String servletLink = ep.getShortName();
                Map servletMappings = webMetaData.getServletMappings();
                String urlPattern = (String)servletMappings.get(servletLink);
                if (urlPattern == null) {
                    throw Messages.MESSAGES.cannotFindUrlPatternForServletName(servletLink);
                }
                List securityList = webMetaData.getSecurityMetaData();
                for (JSESecurityMetaData currentSecurity : securityList) {
                    if (currentSecurity.getTransportGuarantee() == null || currentSecurity.getTransportGuarantee().length() <= 0) continue;
                    for (JSESecurityMetaData.JSEResourceCollection currentCollection : currentSecurity.getWebResources()) {
                        for (String currentUrlPattern : currentCollection.getUrlPatterns()) {
                            if (!urlPattern.equals(currentUrlPattern) && !(urlPattern + "/*").equals(currentUrlPattern) && !"/*".equals(currentUrlPattern)) continue;
                            transportGuarantee = currentSecurity.getTransportGuarantee();
                        }
                    }
                }
            }
        } else if (WSHelper.isJaxwsEjbEndpoint(ep)) {
            Class implClass = ep.getTargetBeanClass();
            WebContext anWebContext = implClass.getAnnotation(WebContext.class);
            if (anWebContext != null) {
                transportGuarantee = anWebContext.transportGuarantee();
            }
            if (anWebContext == null || transportGuarantee == null || transportGuarantee.length() == 0) {
                EJBSecurityMetaData ejbSecurityMD;
                String ejbName = ep.getShortName();
                EJBArchiveMetaData ejbArchiveMD = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
                EJBMetaData ejbMD = ejbArchiveMD != null ? ejbArchiveMD.getBeanByEjbName(ejbName) : null;
                EJBSecurityMetaData eJBSecurityMetaData = ejbSecurityMD = ejbMD != null ? ejbMD.getSecurityMetaData() : null;
                if (ejbSecurityMD != null) {
                    transportGuarantee = ejbSecurityMD.getTransportGuarantee();
                }
            }
        }
        return "CONFIDENTIAL".equals(transportGuarantee);
    }

    private static class PortValue {
        private ServerConfig config;
        private Integer port;
        private Integer securePort;

        public PortValue(Integer port, Integer securePort) {
            this.port = port;
            this.securePort = securePort;
        }

        public void setServerConfig(ServerConfig config) {
            this.port = null;
            this.securePort = null;
            this.config = config;
        }

        public Integer getValue(boolean confidential) {
            return confidential ? this.getSecurePortValue() : this.getPortValue();
        }

        public Integer getPortValue() {
            if (this.port == null && this.config != null) {
                this.port = this.config.getWebServicePort();
            }
            return this.port;
        }

        public Integer getSecurePortValue() {
            if (this.securePort == null && this.config != null) {
                this.securePort = this.config.getWebServiceSecurePort();
            }
            return this.securePort;
        }
    }
}

