/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.extension.UnsupportedSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public abstract class AbstractLegacyExtension
implements Extension {
    private final String extensionName;
    private final List<String> subsystemNames;

    protected AbstractLegacyExtension(String extensionName, String ... subsystemNames) {
        this.extensionName = extensionName;
        this.subsystemNames = Arrays.asList(subsystemNames);
    }

    @Override
    public void initialize(ExtensionContext context) {
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER) {
            ControllerLogger.SERVER_MANAGEMENT_LOGGER.ignoringUnsupportedLegacyExtension(this.subsystemNames, this.extensionName);
            return;
        }
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            throw new UnsupportedOperationException(ControllerMessages.MESSAGES.unsupportedLegacyExtension(this.extensionName));
        }
        Set<ManagementResourceRegistration> subsystemRoots = this.initializeLegacyModel(context);
        for (ManagementResourceRegistration subsystemRoot : subsystemRoots) {
            subsystemRoot.registerOperationHandler(GenericSubsystemDescribeHandler.DEFINITION, new UnsupportedSubsystemDescribeHandler(this.extensionName));
        }
    }

    @Override
    public void initializeParsers(ExtensionParsingContext context) {
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER) {
            return;
        }
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            throw new UnsupportedOperationException(ControllerMessages.MESSAGES.unsupportedLegacyExtension(this.extensionName));
        }
        this.initializeLegacyParsers(context);
    }

    protected abstract Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext var1);

    protected abstract void initializeLegacyParsers(ExtensionParsingContext var1);
}

