/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.saml.SAMLEndpoint;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.SAML2AuthnRequestBuilder;
import org.keycloak.protocol.saml.SAML2LogoutRequestBuilder;
import org.keycloak.protocol.saml.SAML2NameIDPolicyBuilder;
import org.picketlink.common.constants.JBossSAMLURIConstants;

public class SAMLIdentityProvider
extends AbstractIdentityProvider<SAMLIdentityProviderConfig> {
    public SAMLIdentityProvider(SAMLIdentityProviderConfig config) {
        super((IdentityProviderModel)config);
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new SAMLEndpoint(realm, (SAMLIdentityProviderConfig)this.getConfig(), callback);
    }

    public Response handleRequest(AuthenticationRequest request) {
        try {
            UriInfo uriInfo = request.getUriInfo();
            RealmModel realm = request.getRealm();
            String issuerURL = this.getEntityId(uriInfo, realm);
            String destinationUrl = ((SAMLIdentityProviderConfig)this.getConfig()).getSingleSignOnServiceUrl();
            String nameIDPolicyFormat = ((SAMLIdentityProviderConfig)this.getConfig()).getNameIDPolicyFormat();
            if (nameIDPolicyFormat == null) {
                nameIDPolicyFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
            }
            String protocolBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
            String assertionConsumerServiceUrl = request.getRedirectUri();
            if (((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingResponse()) {
                protocolBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
            }
            SAML2AuthnRequestBuilder authnRequestBuilder = (SAML2AuthnRequestBuilder)((SAML2AuthnRequestBuilder)((SAML2AuthnRequestBuilder)new SAML2AuthnRequestBuilder().assertionConsumerUrl(assertionConsumerServiceUrl).destination(destinationUrl)).issuer(issuerURL)).forceAuthn(((SAMLIdentityProviderConfig)this.getConfig()).isForceAuthn()).protocolBinding(protocolBinding).nameIdPolicy(SAML2NameIDPolicyBuilder.format((String)nameIDPolicyFormat)).relayState(request.getState());
            if (((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
                PrivateKey privateKey = realm.getPrivateKey();
                PublicKey publicKey = realm.getPublicKey();
                if (privateKey == null) {
                    throw new IdentityBrokerException("Identity Provider [" + ((SAMLIdentityProviderConfig)this.getConfig()).getAlias() + "] wants a signed authentication request. But the Realm [" + realm.getName() + "] does not have a private key.");
                }
                if (publicKey == null) {
                    throw new IdentityBrokerException("Identity Provider [" + ((SAMLIdentityProviderConfig)this.getConfig()).getAlias() + "] wants a signed authentication request. But the Realm [" + realm.getName() + "] does not have a public key.");
                }
                KeyPair keypair = new KeyPair(publicKey, privateKey);
                authnRequestBuilder.signWith(keypair);
                authnRequestBuilder.signDocument();
            }
            if (((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingAuthnRequest()) {
                return authnRequestBuilder.postBinding().request();
            }
            return authnRequestBuilder.redirectBinding().request();
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not create authentication request.", (Throwable)e);
        }
    }

    private String getEntityId(UriInfo uriInfo, RealmModel realm) {
        return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
    }

    public Response retrieveToken(FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).build();
    }

    public Response keycloakInitiatedBrowserLogout(UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        if (((SAMLIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl() == null || ((SAMLIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl().trim().equals("")) {
            return null;
        }
        SAML2LogoutRequestBuilder logoutBuilder = (SAML2LogoutRequestBuilder)((SAML2LogoutRequestBuilder)new SAML2LogoutRequestBuilder().issuer(this.getEntityId(uriInfo, realm))).sessionIndex(userSession.getNote("SAML_FEDERATED_SESSION_INDEX")).userPrincipal(userSession.getNote("SAML_FEDERATED_SUBJECT"), userSession.getNote("SAML_FEDERATED_SUBJECT_NAMEFORMAT")).destination(((SAMLIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl());
        if (((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
            ((SAML2LogoutRequestBuilder)logoutBuilder.signWith(realm.getPrivateKey(), realm.getPublicKey(), realm.getCertificate())).signDocument();
        }
        try {
            return ((SAML2LogoutRequestBuilder)logoutBuilder.relayState(userSession.getId())).postBinding().request();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Response export(UriInfo uriInfo, RealmModel realm, String format) {
        String authnBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
        if (((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingAuthnRequest()) {
            authnBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
        }
        String endpoint = uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(((SAMLIdentityProviderConfig)this.getConfig()).getAlias()).path("endpoint").build(new Object[0]).toString();
        String descriptor = "<EntityDescriptor entityID=\"" + this.getEntityId(uriInfo, realm) + "\">\n" + "    <SPSSODescriptor AuthnRequestsSigned=\"" + ((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned() + "\"\n" + "            protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol urn:oasis:names:tc:SAML:1.1:protocol http://schemas.xmlsoap.org/ws/2003/07/secext\">\n" + "        <NameIDFormat>" + ((SAMLIdentityProviderConfig)this.getConfig()).getNameIDPolicyFormat() + "\n" + "        </NameIDFormat>\n" + "        <SingleLogoutService Binding=\"" + authnBinding + "\" Location=\"" + endpoint + "\"/>\n" + "        <AssertionConsumerService\n" + "                Binding=\"" + authnBinding + "\" Location=\"" + endpoint + "\"\n" + "                index=\"1\" isDefault=\"true\" />\n";
        if (((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
            descriptor = descriptor + "        <KeyDescriptor use=\"signing\">\n            <dsig:KeyInfo xmlns:dsig=\"http://www.w3.org/2000/09/xmldsig#\">\n                <dsig:X509Data>\n                    <dsig:X509Certificate>\n" + realm.getCertificatePem() + "\n" + "                    </dsig:X509Certificate>\n" + "                </dsig:X509Data>\n" + "            </dsig:KeyInfo>\n" + "        </KeyDescriptor>\n";
        }
        descriptor = descriptor + "    </SPSSODescriptor>\n</EntityDescriptor>\n";
        return Response.ok((Object)descriptor, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }
}

