/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;

public class UndertowMessages_$bundle
implements Serializable,
UndertowMessages {
    private static final long serialVersionUID = 1L;
    public static final UndertowMessages_$bundle INSTANCE = new UndertowMessages_$bundle();
    private static final String maximumConcurrentRequestsMustBeLargerThanZero = "UT000001: Maximum concurrent requests must be larger than zero.";
    private static final String responseAlreadyStarted = "UT000002: The response has already been started";
    private static final String responseChannelAlreadyProvided = "UT000004: getResponseChannel() has already been called";
    private static final String requestChannelAlreadyProvided = "UT000005: getRequestChannel() has already been called";
    private static final String handlerCannotBeNull = "UT000008: Handler cannot be null";
    private static final String pathMustBeSpecified = "UT000009: Path must be specified";
    private static final String sessionNotFound = "UT000010: Session not found %s";
    private static final String sessionManagerMustNotBeNull = "UT000011: Session manager must not be null";
    private static final String sessionManagerNotFound = "UT000012: Session manager was not attached to the request. Make sure that the SessionAttachmentHander is installed in the handler chain";
    private static final String argumentCannotBeNull = "UT000013: Argument %s cannot be null";
    private static final String closeCalledWithDataStillToBeFlushed = "UT000014: close() called with data still to be flushed. Please call shutdownWrites() and then call flush() until it returns true before calling close()";
    private static final String cookieHandlerNotPresent = "UT000016: Could not add cookie as cookie handler was not present in the handler chain";
    private static final String formValueIsAFile = "UT000017: Form value is a file, use getFile() instead";
    private static final String formValueIsAString = "UT000018: Form value is a String, use getValue() instead";
    private static final String requestEntityWasTooLarge2 = "UT000019: Connection from %s terminated as request entity was larger than %s";
    private static final String requestEntityWasTooLarge1 = "UT000020: Connection terminated as request was larger than %s";
    private static final String sessionAlreadyInvalidated = "UT000021: Session already invalidated";
    private static final String hashAlgorithmNotFound = "UT000022: The specified hash algorithm '%s' can not be found.";
    private static final String invalidBase64Token = "UT000023: An invalid Base64 token has been received.";
    private static final String invalidNonceReceived = "UT000024: An invalidly formatted nonce has been received.";
    private static final String unexpectedTokenInHeader = "UT000025: Unexpected token '%s' within header.";
    private static final String invalidHeader = "UT000026: Invalid header received.";
    private static final String couldNotFindSessionCookieConfig = "UT000027: Could not find session cookie config in the request";
    private static final String sessionAlreadyExists = "UT000028: Session %s already exists";
    private static final String chunkedChannelClosedMidChunk = "UT000029: Channel was closed mid chunk, if you have attempted to write chunked data you cannot shutdown the channel until after it has all been written.";
    private static final String userAuthenticated = "UT000030: User %s successfully authenticated.";
    private static final String userLoggedOut = "UT000031: User %s has logged out.";
    private static final String authTypeCannotBeCombined = "UT000033: Authentication type %s cannot be combined with %s";
    private static final String streamIsClosed = "UT000034: Stream is closed";
    private static final String startBlockingHasNotBeenCalled = "UT000035: Cannot get stream as startBlocking has not been invoked";
    private static final String connectionTerminatedReadingMultiPartData = "UT000036: Connection terminated parsing multipart data";
    private static final String failedToParsePath = "UT000037: Failed to parse path in HTTP request";
    private static final String authenticationFailed = "UT000038: Authentication failed, requested user name '%s'";
    private static final String tooManyQueryParameters = "UT000039: To many query parameters, cannot have more than %s query parameters";
    private static final String tooManyHeaders = "UT000040: To many headers, cannot have more than %s header";
    private static final String channelIsClosed = "UT000041: Channel is closed";
    private static final String couldNotDecodeTrailers = "UT000042: Could not decode trailers in HTTP request";
    private static final String dataAlreadyQueued = "UT000043: Data is already being sent. You must wait for the completion callback to be be invoked before calling send() again";
    private static final String moreThanOnePredicateWithName = "UT000044: More than one predicate with name %s. Builder class %s and %s";
    private static final String errorParsingPredicateString = "UT000045: Error parsing predicate string %s:%n%s";
    private static final String tooManyCookies = "UT000046: The number of cookies sent exceeded the maximum of %s";
    private static final String tooManyParameters = "UT000047: The number of parameters exceeded the maximum of %s";
    private static final String noRequestActive = "UT000048: No request is currently active";
    private static final String authMechanismOutcomeNull = "UT000050: AuthenticationMechanism Outcome is null";
    private static final String notAValidIpPattern = "UT000051: Not a valid IP pattern %s";
    private static final String noSessionData = "UT000052: Session data requested when non session based authentication in use";
    private static final String listenerAlreadyRegistered = "UT000053: Listener %s already registered";
    private static final String maxFileSizeExceeded = "UT000054: The maximum size %s for an individual file in a multipart request was exceeded";
    private static final String couldNotSetAttribute = "UT000055: Could not set attribute %s to %s as it is read only";
    private static final String couldNotParseUriTemplate = "UT000056: Could not parse URI template %s, exception at char %s";
    private static final String mismatchedBraces = "UT000057: Mismatched braces in attribute string %s";
    private static final String moreThanOneHandlerWithName = "UT000058: More than one handler with name %s. Builder class %s and %s";
    private static final String invalidSyntax = "UT000059: Invalid syntax %s";
    private static final String errorParsingHandlerString = "UT000060: Error parsing handler string %s:%n%s";
    private static final String outOfBandResponseOnlyAllowedFor100Continue = "UT000061: Out of band responses only allowed for 100-continue requests";
    private static final String ajpDoesNotSupportHTTPUpgrade = "UT000062: AJP does not support HTTP upgrade";
    private static final String fileSystemWatcherAlreadyStarted = "UT000063: File system watcher already started";
    private static final String fileSystemWatcherNotStarted = "UT000064: File system watcher not started";
    private static final String sslWasNull = "UT000065: SSL must be specified to connect to a https URL";
    private static final String wrongMagicNumber = "UT000066: Incorrect magic number for AJP packet header";
    private static final String peerUnverified = "UT000067: No client cert was provided";
    private static final String servletPathMatchFailed = "UT000068: Servlet path match failed";
    private static final String couldNotParseCookie = "UT000069: Could not parse set cookie header %s";
    private static final String canOnlyBeCalledByIoThread = "UT000070: method can only be called by IO thread";
    private static final String matcherAlreadyContainsTemplate = "UT000071: Cannot add path template %s, matcher already contains an equivalent pattern %s";
    private static final String failedToDecodeURL = "UT000072: Failed to decode url %s to charset %s";
    private static final String resourceChangeListenerNotSupported = "UT000073: Resource change listeners are not supported";
    private static final String couldNotRenegotiate = "UT000074: Could not renegotiate SSL connection to require client certificate, as client had sent more data";
    private static final String objectWasFreed = "UT000075: Object was freed";
    private static final String handlerNotShutdown = "UT000076: Handler not shutdown";
    private static final String upgradeNotSupported = "UT000077: The underlying transport does not support HTTP upgrade";
    private static final String renegotiationNotSupported = "UT000078: Renegotiation not supported";
    private static final String notAValidUserAgentPattern = "UT000079: Not a valid user agent pattern %s";
    private static final String notAValidRegularExpressionPattern = "UT000080: Not a valid regular expression pattern %s";
    private static final String badRequest = "UT000081: Bad request";
    private static final String hostAlreadyRegistered = "UT000082: Host %s already registered";
    private static final String hostHasNotBeenRegistered = "UT000083: Host %s has not been registered";
    private static final String extraDataWrittenAfterChunkEnd = "UT000084: Attempted to write additional data after the last chunk";
    private static final String couldNotGenerateUniqueSessionId = "UT000085: Could not generate unique session id";
    private static final String mustProvideHeapBuffer = "UT000086: SPDY needs to be provided with a heap buffer pool, for use in compressing and decompressing headers.";
    private static final String unexpectedFrameType = "UT000087: Unexpected SPDY frame type %s";
    private static final String controlFrameCannotHaveBodyContent = "UT000088: SPDY control frames cannot have body content";
    private static final String spdyNotSupported = "UT000089: SPDY not supported";
    private static final String jettyNPNNotAvailable = "UT000090: Jetty NPN not available";
    private static final String bufferAlreadyFreed = "UT000091: Buffer has already been freed";
    private static final String headersTooLargeToFitInHeapBuffer = "UT000092: A SPDY header was too large to fit in a response buffer, if you want to support larger headers please increase the buffer size";
    private static final String spdyStreamWasReset = "UT000093: A SPDY stream was reset by the remote endpoint";
    private static final String awaitCalledFromIoThread = "UT000094: Blocking await method called from IO thread. Blocking IO must be dispatched to a worker thread or deadlocks will result.";
    private static final String recursiveCallToFlushingSenders = "UT000095: Recursive call to flushSenders()";
    private static final String fixedLengthOverflow = "UT000096: More data was written to the channel than specified in the content-length";
    private static final String ajpRequestAlreadyInProgress = "UT000097: AJP request already in progress";
    private static final String httpPingDataMustBeLength8 = "UT000098: HTTP ping data must be 8 bytes in length";
    private static final String invalidPingSize = "UT000099: Received a ping of size other than 8";
    private static final String streamIdMustBeZeroForFrameType = "UT000100: stream id must be zero for frame type %s";
    private static final String streamIdMustNotBeZeroForFrameType = "UT000101: stream id must not be zero for frame type %s";
    private static final String rstStreamReceivedForIdleStream = "UT000102: RST_STREAM received for idle stream";
    private static final String http2StreamWasReset = "UT000103: Http2 stream was reset";
    private static final String incorrectHttp2Preface = "UT000104: Incorrect HTTP2 preface";
    private static final String http2FrameTooLarge = "UT000105: HTTP2 frame to large";
    private static final String http2ContinuationFrameNotExpected = "UT000106: HTTP2 continuation frame received without a corresponding headers or push promise frame";
    private static final String cannotSendContinueResponse = "UT000110: Cannot send 100-Continue, getResponseChannel() has already been called";
    private static final String parserDidNotMakeProgress = "UT000111: Parser did not make progress";
    private static final String headersStreamCanOnlyBeCreatedByClient = "UT000112: Only client side can call createStream, if you wish to send a PUSH_PROMISE frame use createPushPromiseStream instead";
    private static final String invalidAclRule = "UT000114: Invalid IP access control rule %s. Format is: [ip-match] allow|deny";

    protected UndertowMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalArgumentException maximumConcurrentRequestsMustBeLargerThanZero() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.maximumConcurrentRequestsMustBeLargerThanZero$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String maximumConcurrentRequestsMustBeLargerThanZero$str() {
        return maximumConcurrentRequestsMustBeLargerThanZero;
    }

    @Override
    public final IllegalStateException responseAlreadyStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.responseAlreadyStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String responseAlreadyStarted$str() {
        return responseAlreadyStarted;
    }

    @Override
    public final IllegalStateException responseChannelAlreadyProvided() {
        IllegalStateException result = new IllegalStateException(String.format(this.responseChannelAlreadyProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String responseChannelAlreadyProvided$str() {
        return responseChannelAlreadyProvided;
    }

    @Override
    public final IllegalStateException requestChannelAlreadyProvided() {
        IllegalStateException result = new IllegalStateException(String.format(this.requestChannelAlreadyProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestChannelAlreadyProvided$str() {
        return requestChannelAlreadyProvided;
    }

    @Override
    public final IllegalArgumentException handlerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.handlerCannotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerCannotBeNull$str() {
        return handlerCannotBeNull;
    }

    @Override
    public final IllegalArgumentException pathMustBeSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.pathMustBeSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String pathMustBeSpecified$str() {
        return pathMustBeSpecified;
    }

    @Override
    public final IllegalStateException sessionNotFound(String session) {
        IllegalStateException result = new IllegalStateException(String.format(this.sessionNotFound$str(), session));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionNotFound$str() {
        return sessionNotFound;
    }

    @Override
    public final IllegalStateException sessionManagerMustNotBeNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.sessionManagerMustNotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionManagerMustNotBeNull$str() {
        return sessionManagerMustNotBeNull;
    }

    @Override
    public final IllegalStateException sessionManagerNotFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.sessionManagerNotFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionManagerNotFound$str() {
        return sessionManagerNotFound;
    }

    @Override
    public final IllegalArgumentException argumentCannotBeNull(String argument) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.argumentCannotBeNull$str(), argument));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String argumentCannotBeNull$str() {
        return argumentCannotBeNull;
    }

    @Override
    public final IOException closeCalledWithDataStillToBeFlushed() {
        IOException result = new IOException(String.format(this.closeCalledWithDataStillToBeFlushed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closeCalledWithDataStillToBeFlushed$str() {
        return closeCalledWithDataStillToBeFlushed;
    }

    @Override
    public final IllegalStateException cookieHandlerNotPresent() {
        IllegalStateException result = new IllegalStateException(String.format(this.cookieHandlerNotPresent$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cookieHandlerNotPresent$str() {
        return cookieHandlerNotPresent;
    }

    @Override
    public final IllegalStateException formValueIsAFile() {
        IllegalStateException result = new IllegalStateException(String.format(this.formValueIsAFile$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String formValueIsAFile$str() {
        return formValueIsAFile;
    }

    @Override
    public final IllegalStateException formValueIsAString() {
        IllegalStateException result = new IllegalStateException(String.format(this.formValueIsAString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String formValueIsAString$str() {
        return formValueIsAString;
    }

    @Override
    public final IOException requestEntityWasTooLarge(SocketAddress address, long size) {
        IOException result = new IOException(String.format(this.requestEntityWasTooLarge2$str(), address, size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestEntityWasTooLarge2$str() {
        return requestEntityWasTooLarge2;
    }

    @Override
    public final IOException requestEntityWasTooLarge(long size) {
        IOException result = new IOException(String.format(this.requestEntityWasTooLarge1$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestEntityWasTooLarge1$str() {
        return requestEntityWasTooLarge1;
    }

    @Override
    public final IllegalStateException sessionAlreadyInvalidated() {
        IllegalStateException result = new IllegalStateException(String.format(this.sessionAlreadyInvalidated$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionAlreadyInvalidated$str() {
        return sessionAlreadyInvalidated;
    }

    @Override
    public final IllegalArgumentException hashAlgorithmNotFound(String algorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.hashAlgorithmNotFound$str(), algorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hashAlgorithmNotFound$str() {
        return hashAlgorithmNotFound;
    }

    @Override
    public final IllegalArgumentException invalidBase64Token(IOException cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidBase64Token$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidBase64Token$str() {
        return invalidBase64Token;
    }

    @Override
    public final IllegalArgumentException invalidNonceReceived() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidNonceReceived$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNonceReceived$str() {
        return invalidNonceReceived;
    }

    @Override
    public final IllegalArgumentException unexpectedTokenInHeader(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unexpectedTokenInHeader$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedTokenInHeader$str() {
        return unexpectedTokenInHeader;
    }

    @Override
    public final IllegalArgumentException invalidHeader() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidHeader$str() {
        return invalidHeader;
    }

    @Override
    public final IllegalStateException couldNotFindSessionCookieConfig() {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotFindSessionCookieConfig$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotFindSessionCookieConfig$str() {
        return couldNotFindSessionCookieConfig;
    }

    @Override
    public final IllegalStateException sessionAlreadyExists(String id) {
        IllegalStateException result = new IllegalStateException(String.format(this.sessionAlreadyExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionAlreadyExists$str() {
        return sessionAlreadyExists;
    }

    @Override
    public final IOException chunkedChannelClosedMidChunk() {
        IOException result = new IOException(String.format(this.chunkedChannelClosedMidChunk$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String chunkedChannelClosedMidChunk$str() {
        return chunkedChannelClosedMidChunk;
    }

    @Override
    public final String userAuthenticated(String userName) {
        String result = String.format(this.userAuthenticated$str(), userName);
        return result;
    }

    protected String userAuthenticated$str() {
        return userAuthenticated;
    }

    @Override
    public final String userLoggedOut(String userName) {
        String result = String.format(this.userLoggedOut$str(), userName);
        return result;
    }

    protected String userLoggedOut$str() {
        return userLoggedOut;
    }

    @Override
    public final IllegalStateException authTypeCannotBeCombined(String type, String existing) {
        IllegalStateException result = new IllegalStateException(String.format(this.authTypeCannotBeCombined$str(), type, existing));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authTypeCannotBeCombined$str() {
        return authTypeCannotBeCombined;
    }

    @Override
    public final IOException streamIsClosed() {
        IOException result = new IOException(String.format(this.streamIsClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String streamIsClosed$str() {
        return streamIsClosed;
    }

    @Override
    public final IllegalStateException startBlockingHasNotBeenCalled() {
        IllegalStateException result = new IllegalStateException(String.format(this.startBlockingHasNotBeenCalled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String startBlockingHasNotBeenCalled$str() {
        return startBlockingHasNotBeenCalled;
    }

    @Override
    public final IOException connectionTerminatedReadingMultiPartData() {
        IOException result = new IOException(String.format(this.connectionTerminatedReadingMultiPartData$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTerminatedReadingMultiPartData$str() {
        return connectionTerminatedReadingMultiPartData;
    }

    @Override
    public final RuntimeException failedToParsePath() {
        RuntimeException result = new RuntimeException(String.format(this.failedToParsePath$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToParsePath$str() {
        return failedToParsePath;
    }

    @Override
    public final String authenticationFailed(String userName) {
        String result = String.format(this.authenticationFailed$str(), userName);
        return result;
    }

    protected String authenticationFailed$str() {
        return authenticationFailed;
    }

    @Override
    public final RuntimeException tooManyQueryParameters(int noParams) {
        RuntimeException result = new RuntimeException(String.format(this.tooManyQueryParameters$str(), noParams));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tooManyQueryParameters$str() {
        return tooManyQueryParameters;
    }

    @Override
    public final RuntimeException tooManyHeaders(int noParams) {
        RuntimeException result = new RuntimeException(String.format(this.tooManyHeaders$str(), noParams));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tooManyHeaders$str() {
        return tooManyHeaders;
    }

    @Override
    public final ClosedChannelException channelIsClosed() {
        ClosedChannelException result = new ClosedChannelException();
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelIsClosed$str() {
        return channelIsClosed;
    }

    @Override
    public final IOException couldNotDecodeTrailers() {
        IOException result = new IOException(String.format(this.couldNotDecodeTrailers$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotDecodeTrailers$str() {
        return couldNotDecodeTrailers;
    }

    @Override
    public final IllegalStateException dataAlreadyQueued() {
        IllegalStateException result = new IllegalStateException(String.format(this.dataAlreadyQueued$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dataAlreadyQueued$str() {
        return dataAlreadyQueued;
    }

    public final IllegalStateException moreThanOnePredicateWithName(String name, Class aClass, Class existing) {
        IllegalStateException result = new IllegalStateException(String.format(this.moreThanOnePredicateWithName$str(), name, aClass, existing));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String moreThanOnePredicateWithName$str() {
        return moreThanOnePredicateWithName;
    }

    @Override
    public final IllegalArgumentException errorParsingPredicateString(String reason, String s) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.errorParsingPredicateString$str(), reason, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorParsingPredicateString$str() {
        return errorParsingPredicateString;
    }

    @Override
    public final IllegalStateException tooManyCookies(int maxCookies) {
        IllegalStateException result = new IllegalStateException(String.format(this.tooManyCookies$str(), maxCookies));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tooManyCookies$str() {
        return tooManyCookies;
    }

    @Override
    public final IllegalStateException tooManyParameters(int maxValues) {
        IllegalStateException result = new IllegalStateException(String.format(this.tooManyParameters$str(), maxValues));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tooManyParameters$str() {
        return tooManyParameters;
    }

    @Override
    public final IllegalStateException noRequestActive() {
        IllegalStateException result = new IllegalStateException(String.format(this.noRequestActive$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noRequestActive$str() {
        return noRequestActive;
    }

    @Override
    public final IllegalStateException authMechanismOutcomeNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.authMechanismOutcomeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authMechanismOutcomeNull$str() {
        return authMechanismOutcomeNull;
    }

    @Override
    public final IllegalArgumentException notAValidIpPattern(String peer) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.notAValidIpPattern$str(), peer));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAValidIpPattern$str() {
        return notAValidIpPattern;
    }

    @Override
    public final IllegalStateException noSessionData() {
        IllegalStateException result = new IllegalStateException(String.format(this.noSessionData$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSessionData$str() {
        return noSessionData;
    }

    @Override
    public final IllegalArgumentException listenerAlreadyRegistered(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.listenerAlreadyRegistered$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String listenerAlreadyRegistered$str() {
        return listenerAlreadyRegistered;
    }

    @Override
    public final IOException maxFileSizeExceeded(long maxIndividualFileSize) {
        IOException result = new IOException(String.format(this.maxFileSizeExceeded$str(), maxIndividualFileSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String maxFileSizeExceeded$str() {
        return maxFileSizeExceeded;
    }

    @Override
    public final String couldNotSetAttribute(String attributeName, String newValue) {
        String result = String.format(this.couldNotSetAttribute$str(), attributeName, newValue);
        return result;
    }

    protected String couldNotSetAttribute$str() {
        return couldNotSetAttribute;
    }

    @Override
    public final RuntimeException couldNotParseUriTemplate(String path, int i) {
        RuntimeException result = new RuntimeException(String.format(this.couldNotParseUriTemplate$str(), path, i));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotParseUriTemplate$str() {
        return couldNotParseUriTemplate;
    }

    @Override
    public final RuntimeException mismatchedBraces(String valueString) {
        RuntimeException result = new RuntimeException(String.format(this.mismatchedBraces$str(), valueString));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mismatchedBraces$str() {
        return mismatchedBraces;
    }

    public final IllegalStateException moreThanOneHandlerWithName(String name, Class aClass, Class existing) {
        IllegalStateException result = new IllegalStateException(String.format(this.moreThanOneHandlerWithName$str(), name, aClass, existing));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String moreThanOneHandlerWithName$str() {
        return moreThanOneHandlerWithName;
    }

    @Override
    public final IllegalArgumentException invalidSyntax(String line) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidSyntax$str(), line));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSyntax$str() {
        return invalidSyntax;
    }

    @Override
    public final IllegalArgumentException errorParsingHandlerString(String reason, String s) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.errorParsingHandlerString$str(), reason, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorParsingHandlerString$str() {
        return errorParsingHandlerString;
    }

    @Override
    public final IllegalArgumentException outOfBandResponseOnlyAllowedFor100Continue() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.outOfBandResponseOnlyAllowedFor100Continue$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String outOfBandResponseOnlyAllowedFor100Continue$str() {
        return outOfBandResponseOnlyAllowedFor100Continue;
    }

    @Override
    public final IllegalStateException ajpDoesNotSupportHTTPUpgrade() {
        IllegalStateException result = new IllegalStateException(String.format(this.ajpDoesNotSupportHTTPUpgrade$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ajpDoesNotSupportHTTPUpgrade$str() {
        return ajpDoesNotSupportHTTPUpgrade;
    }

    @Override
    public final IllegalStateException fileSystemWatcherAlreadyStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.fileSystemWatcherAlreadyStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemWatcherAlreadyStarted$str() {
        return fileSystemWatcherAlreadyStarted;
    }

    @Override
    public final IllegalStateException fileSystemWatcherNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.fileSystemWatcherNotStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemWatcherNotStarted$str() {
        return fileSystemWatcherNotStarted;
    }

    @Override
    public final IOException sslWasNull() {
        IOException result = new IOException(String.format(this.sslWasNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sslWasNull$str() {
        return sslWasNull;
    }

    @Override
    public final IOException wrongMagicNumber() {
        IOException result = new IOException(String.format(this.wrongMagicNumber$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wrongMagicNumber$str() {
        return wrongMagicNumber;
    }

    @Override
    public final SSLPeerUnverifiedException peerUnverified() {
        SSLPeerUnverifiedException result = new SSLPeerUnverifiedException(String.format(this.peerUnverified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String peerUnverified$str() {
        return peerUnverified;
    }

    @Override
    public final IllegalArgumentException servletPathMatchFailed() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.servletPathMatchFailed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String servletPathMatchFailed$str() {
        return servletPathMatchFailed;
    }

    @Override
    public final IllegalArgumentException couldNotParseCookie(String headerValue) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.couldNotParseCookie$str(), headerValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotParseCookie$str() {
        return couldNotParseCookie;
    }

    @Override
    public final IllegalStateException canOnlyBeCalledByIoThread() {
        IllegalStateException result = new IllegalStateException(String.format(this.canOnlyBeCalledByIoThread$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String canOnlyBeCalledByIoThread$str() {
        return canOnlyBeCalledByIoThread;
    }

    @Override
    public final IllegalStateException matcherAlreadyContainsTemplate(String templateString, String templateString1) {
        IllegalStateException result = new IllegalStateException(String.format(this.matcherAlreadyContainsTemplate$str(), templateString, templateString1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String matcherAlreadyContainsTemplate$str() {
        return matcherAlreadyContainsTemplate;
    }

    @Override
    public final IllegalArgumentException failedToDecodeURL(String s, String enc) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.failedToDecodeURL$str(), s, enc));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToDecodeURL$str() {
        return failedToDecodeURL;
    }

    @Override
    public final IllegalArgumentException resourceChangeListenerNotSupported() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.resourceChangeListenerNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String resourceChangeListenerNotSupported$str() {
        return resourceChangeListenerNotSupported;
    }

    @Override
    public final IllegalStateException couldNotRenegotiate() {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotRenegotiate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotRenegotiate$str() {
        return couldNotRenegotiate;
    }

    @Override
    public final IllegalStateException objectWasFreed() {
        IllegalStateException result = new IllegalStateException(String.format(this.objectWasFreed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String objectWasFreed$str() {
        return objectWasFreed;
    }

    @Override
    public final IllegalStateException handlerNotShutdown() {
        IllegalStateException result = new IllegalStateException(String.format(this.handlerNotShutdown$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerNotShutdown$str() {
        return handlerNotShutdown;
    }

    @Override
    public final IllegalStateException upgradeNotSupported() {
        IllegalStateException result = new IllegalStateException(String.format(this.upgradeNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String upgradeNotSupported$str() {
        return upgradeNotSupported;
    }

    @Override
    public final IOException renegotiationNotSupported() {
        IOException result = new IOException(String.format(this.renegotiationNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String renegotiationNotSupported$str() {
        return renegotiationNotSupported;
    }

    @Override
    public final IllegalArgumentException notAValidUserAgentPattern(String userAgent) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.notAValidUserAgentPattern$str(), userAgent));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAValidUserAgentPattern$str() {
        return notAValidUserAgentPattern;
    }

    @Override
    public final IllegalArgumentException notAValidRegularExpressionPattern(String pattern) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.notAValidRegularExpressionPattern$str(), pattern));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAValidRegularExpressionPattern$str() {
        return notAValidRegularExpressionPattern;
    }

    @Override
    public final RuntimeException badRequest() {
        RuntimeException result = new RuntimeException(String.format(this.badRequest$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badRequest$str() {
        return badRequest;
    }

    @Override
    public final RuntimeException hostAlreadyRegistered(Object host) {
        RuntimeException result = new RuntimeException(String.format(this.hostAlreadyRegistered$str(), host));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostAlreadyRegistered$str() {
        return hostAlreadyRegistered;
    }

    @Override
    public final RuntimeException hostHasNotBeenRegistered(Object host) {
        RuntimeException result = new RuntimeException(String.format(this.hostHasNotBeenRegistered$str(), host));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostHasNotBeenRegistered$str() {
        return hostHasNotBeenRegistered;
    }

    @Override
    public final IOException extraDataWrittenAfterChunkEnd() {
        IOException result = new IOException(String.format(this.extraDataWrittenAfterChunkEnd$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extraDataWrittenAfterChunkEnd$str() {
        return extraDataWrittenAfterChunkEnd;
    }

    @Override
    public final RuntimeException couldNotGenerateUniqueSessionId() {
        RuntimeException result = new RuntimeException(String.format(this.couldNotGenerateUniqueSessionId$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotGenerateUniqueSessionId$str() {
        return couldNotGenerateUniqueSessionId;
    }

    @Override
    public final IllegalArgumentException mustProvideHeapBuffer() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.mustProvideHeapBuffer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustProvideHeapBuffer$str() {
        return mustProvideHeapBuffer;
    }

    @Override
    public final IOException unexpectedFrameType(int type) {
        IOException result = new IOException(String.format(this.unexpectedFrameType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedFrameType$str() {
        return unexpectedFrameType;
    }

    @Override
    public final IOException controlFrameCannotHaveBodyContent() {
        IOException result = new IOException(String.format(this.controlFrameCannotHaveBodyContent$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String controlFrameCannotHaveBodyContent$str() {
        return controlFrameCannotHaveBodyContent;
    }

    @Override
    public final IOException spdyNotSupported() {
        IOException result = new IOException(String.format(this.spdyNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spdyNotSupported$str() {
        return spdyNotSupported;
    }

    @Override
    public final IOException jettyNPNNotAvailable() {
        IOException result = new IOException(String.format(this.jettyNPNNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jettyNPNNotAvailable$str() {
        return jettyNPNNotAvailable;
    }

    @Override
    public final IllegalStateException bufferAlreadyFreed() {
        IllegalStateException result = new IllegalStateException(String.format(this.bufferAlreadyFreed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bufferAlreadyFreed$str() {
        return bufferAlreadyFreed;
    }

    @Override
    public final IllegalStateException headersTooLargeToFitInHeapBuffer() {
        IllegalStateException result = new IllegalStateException(String.format(this.headersTooLargeToFitInHeapBuffer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headersTooLargeToFitInHeapBuffer$str() {
        return headersTooLargeToFitInHeapBuffer;
    }

    @Override
    public final IOException spdyStreamWasReset() {
        IOException result = new IOException(String.format(this.spdyStreamWasReset$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spdyStreamWasReset$str() {
        return spdyStreamWasReset;
    }

    @Override
    public final IOException awaitCalledFromIoThread() {
        IOException result = new IOException(String.format(this.awaitCalledFromIoThread$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String awaitCalledFromIoThread$str() {
        return awaitCalledFromIoThread;
    }

    @Override
    public final RuntimeException recursiveCallToFlushingSenders() {
        RuntimeException result = new RuntimeException(String.format(this.recursiveCallToFlushingSenders$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String recursiveCallToFlushingSenders$str() {
        return recursiveCallToFlushingSenders;
    }

    @Override
    public final IllegalStateException fixedLengthOverflow() {
        IllegalStateException result = new IllegalStateException(String.format(this.fixedLengthOverflow$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fixedLengthOverflow$str() {
        return fixedLengthOverflow;
    }

    @Override
    public final IllegalStateException ajpRequestAlreadyInProgress() {
        IllegalStateException result = new IllegalStateException(String.format(this.ajpRequestAlreadyInProgress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ajpRequestAlreadyInProgress$str() {
        return ajpRequestAlreadyInProgress;
    }

    @Override
    public final IllegalArgumentException httpPingDataMustBeLength8() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.httpPingDataMustBeLength8$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String httpPingDataMustBeLength8$str() {
        return httpPingDataMustBeLength8;
    }

    @Override
    public final String invalidPingSize() {
        String result = String.format(this.invalidPingSize$str(), new Object[0]);
        return result;
    }

    protected String invalidPingSize$str() {
        return invalidPingSize;
    }

    @Override
    public final String streamIdMustBeZeroForFrameType(int frameType) {
        String result = String.format(this.streamIdMustBeZeroForFrameType$str(), frameType);
        return result;
    }

    protected String streamIdMustBeZeroForFrameType$str() {
        return streamIdMustBeZeroForFrameType;
    }

    @Override
    public final String streamIdMustNotBeZeroForFrameType(int frameType) {
        String result = String.format(this.streamIdMustNotBeZeroForFrameType$str(), frameType);
        return result;
    }

    protected String streamIdMustNotBeZeroForFrameType$str() {
        return streamIdMustNotBeZeroForFrameType;
    }

    @Override
    public final String rstStreamReceivedForIdleStream() {
        String result = String.format(this.rstStreamReceivedForIdleStream$str(), new Object[0]);
        return result;
    }

    protected String rstStreamReceivedForIdleStream$str() {
        return rstStreamReceivedForIdleStream;
    }

    @Override
    public final IOException http2StreamWasReset() {
        IOException result = new IOException(String.format(this.http2StreamWasReset$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String http2StreamWasReset$str() {
        return http2StreamWasReset;
    }

    @Override
    public final IOException incorrectHttp2Preface() {
        IOException result = new IOException(String.format(this.incorrectHttp2Preface$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incorrectHttp2Preface$str() {
        return incorrectHttp2Preface;
    }

    @Override
    public final IOException http2FrameTooLarge() {
        IOException result = new IOException(String.format(this.http2FrameTooLarge$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String http2FrameTooLarge$str() {
        return http2FrameTooLarge;
    }

    @Override
    public final IOException http2ContinuationFrameNotExpected() {
        IOException result = new IOException(String.format(this.http2ContinuationFrameNotExpected$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String http2ContinuationFrameNotExpected$str() {
        return http2ContinuationFrameNotExpected;
    }

    @Override
    public final IOException cannotSendContinueResponse() {
        IOException result = new IOException(String.format(this.cannotSendContinueResponse$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSendContinueResponse$str() {
        return cannotSendContinueResponse;
    }

    @Override
    public final IOException parserDidNotMakeProgress() {
        IOException result = new IOException(String.format(this.parserDidNotMakeProgress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parserDidNotMakeProgress$str() {
        return parserDidNotMakeProgress;
    }

    @Override
    public final IOException headersStreamCanOnlyBeCreatedByClient() {
        IOException result = new IOException(String.format(this.headersStreamCanOnlyBeCreatedByClient$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headersStreamCanOnlyBeCreatedByClient$str() {
        return headersStreamCanOnlyBeCreatedByClient;
    }

    @Override
    public final IllegalArgumentException invalidAclRule(String rule) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidAclRule$str(), rule));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAclRule$str() {
        return invalidAclRule;
    }
}

