/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ajp;

import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class AbstractAjpParser {
    public static final int STRING_LENGTH_MASK = Integer.MIN_VALUE;
    public int stringLength = -1;
    public StringBuilder currentString;
    public int currentIntegerPart = -1;
    boolean containsUrlCharacters = false;
    public int readHeaders = 0;

    AbstractAjpParser() {
    }

    public void reset() {
        this.stringLength = -1;
        this.currentString = null;
        this.currentIntegerPart = -1;
        this.readHeaders = 0;
    }

    public abstract void parse(ByteBuffer var1) throws IOException;

    protected IntegerHolder parse16BitInteger(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return new IntegerHolder(-1, false);
        }
        int number = this.currentIntegerPart;
        if (number == -1) {
            number = buf.get() & 0xFF;
        }
        if (buf.hasRemaining()) {
            byte b = buf.get();
            int result = ((0xFF & number) << 8) + (b & 0xFF);
            this.currentIntegerPart = -1;
            return new IntegerHolder(result, true);
        }
        this.currentIntegerPart = number;
        return new IntegerHolder(-1, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected StringHolder parseString(ByteBuffer buf, boolean header) {
        int number;
        boolean containsUrlCharacters = this.containsUrlCharacters;
        if (!buf.hasRemaining()) {
            return new StringHolder(null, false, false);
        }
        int stringLength = this.stringLength;
        if (stringLength == -1) {
            number = buf.get() & 0xFF;
            if (!buf.hasRemaining()) {
                this.stringLength = number | Integer.MIN_VALUE;
                return new StringHolder(null, false, false);
            }
            byte b = buf.get();
            stringLength = ((0xFF & number) << 8) + (b & 0xFF);
        } else if ((stringLength & Integer.MIN_VALUE) != 0) {
            number = stringLength & Integer.MAX_VALUE;
            stringLength = ((0xFF & number) << 8) + (buf.get() & 0xFF);
        }
        if (header && (stringLength & 0xFF00) != 0) {
            this.stringLength = -1;
            return new StringHolder(this.headers(stringLength & 0xFF));
        }
        if (stringLength == 65535) {
            this.stringLength = -1;
            return new StringHolder(null, true, false);
        }
        StringBuilder builder = this.currentString;
        if (builder == null) {
            this.currentString = builder = new StringBuilder();
        }
        for (int length = builder.length(); length < stringLength; ++length) {
            if (!buf.hasRemaining()) {
                this.stringLength = stringLength;
                this.containsUrlCharacters = containsUrlCharacters;
                return new StringHolder(null, false, false);
            }
            char c = (char)buf.get();
            if (c == '+' || c == '%') {
                containsUrlCharacters = true;
            }
            builder.append(c);
        }
        if (buf.hasRemaining()) {
            buf.get();
            this.currentString = null;
            this.stringLength = -1;
            this.containsUrlCharacters = false;
            return new StringHolder(builder.toString(), true, containsUrlCharacters);
        }
        this.stringLength = stringLength;
        this.containsUrlCharacters = containsUrlCharacters;
        return new StringHolder(null, false, false);
    }

    public abstract boolean isComplete();

    protected abstract HttpString headers(int var1);

    protected static class StringHolder {
        public final String value;
        public final HttpString header;
        public final boolean readComplete;
        public final boolean containsUrlCharacters;

        private StringHolder(String value, boolean readComplete, boolean containsUrlCharacters) {
            this.value = value;
            this.readComplete = readComplete;
            this.containsUrlCharacters = containsUrlCharacters;
            this.header = null;
        }

        private StringHolder(HttpString value) {
            this.value = null;
            this.readComplete = true;
            this.header = value;
            this.containsUrlCharacters = false;
        }
    }

    protected static class IntegerHolder {
        public final int value;
        public final boolean readComplete;

        private IntegerHolder(int value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
        }
    }
}

