/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.nio.charset.StandardCharsets;

public class SimpleBytes {
    private int step;
    private byte[] contents;
    private int index;

    public SimpleBytes(int initCapacity) {
        this.step = initCapacity;
        this.contents = new byte[initCapacity];
        this.index = 0;
    }

    public String getString() {
        if (this.index == 0) {
            return "";
        }
        byte[] realData = new byte[this.index];
        System.arraycopy(this.contents, 0, realData, 0, realData.length);
        return new String(realData, StandardCharsets.UTF_8);
    }

    public void reset() {
        this.index = 0;
    }

    public void append(byte b) {
        if (this.index >= this.contents.length) {
            byte[] newBuffer = new byte[this.contents.length + this.step];
            System.arraycopy(this.contents, 0, newBuffer, 0, this.contents.length);
            this.contents = newBuffer;
        }
        this.contents[this.index++] = b;
    }
}

