/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

abstract class AbstractTrustManagerService
implements Service<TrustManager[]> {
    private volatile TrustManager[] theTrustManagers;

    AbstractTrustManagerService() {
    }

    public void start(StartContext context) throws StartException {
        try {
            this.theTrustManagers = this.createTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
        catch (KeyStoreException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
        this.theTrustManagers = null;
    }

    public TrustManager[] getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theTrustManagers;
    }

    protected TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        KeyStore trustStore = this.loadTrustStore();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    protected abstract KeyStore loadTrustStore();

    static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "trust-manager";

        ServiceUtil() {
        }

        public static ServiceName createServiceName(ServiceName parentService) {
            return parentService.append(new String[]{SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<TrustManager[]> injector, ServiceName parentService) {
            sb.addDependency(ServiceUtil.createServiceName(parentService), TrustManager[].class, injector);
            return sb;
        }
    }
}

