/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmChildAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildRemoveHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class LdapCacheResourceDefinition
extends SimpleResourceDefinition {
    private static final CacheDefintionValidatingHandler VALIDATION_INSTANCE = new CacheDefintionValidatingHandler();
    public static final SimpleAttributeDefinition EVICTION_TIME = new SimpleAttributeDefinitionBuilder("eviction-time", ModelType.INT, true).setAllowExpression(true).setDefaultValue(new ModelNode().set(900)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setMeasurementUnit(MeasurementUnit.SECONDS).build();
    public static final SimpleAttributeDefinition CACHE_FAILURES = new SimpleAttributeDefinitionBuilder("cache-failures", ModelType.BOOLEAN, true).setAllowExpression(true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition MAX_CACHE_SIZE = new SimpleAttributeDefinitionBuilder("max-cache-size", ModelType.INT, true).setAllowExpression(true).setDefaultValue(new ModelNode().set(0)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build();
    public static final SimpleAttributeDefinition CACHE_SIZE = new SimpleAttributeDefinitionBuilder("cache-size", ModelType.INT).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).setMeasurementUnit(MeasurementUnit.SECONDS).build();
    public static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinition("name", ModelType.STRING, true);
    public static final SimpleAttributeDefinition NAME_REQUIRED = new SimpleAttributeDefinition("name", ModelType.STRING, false);
    public static final SimpleAttributeDefinition DISTINGUISHED_NAME = new SimpleAttributeDefinition("distinguished-name", ModelType.STRING, true);
    public static final SimpleOperationDefinition FLUSH_CACHE_NAME_ONLY = new SimpleOperationDefinitionBuilder("flush-cache", ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.ldap.cache"})).setEntryType(OperationEntry.EntryType.PUBLIC).addParameter((AttributeDefinition)NAME).setRuntimeOnly().build();
    public static final SimpleOperationDefinition FLUSH_CACHE_FULL = new SimpleOperationDefinitionBuilder("flush-cache", ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.ldap.cache"})).setEntryType(OperationEntry.EntryType.PUBLIC).addParameter((AttributeDefinition)NAME).addParameter((AttributeDefinition)DISTINGUISHED_NAME).setRuntimeOnly().build();
    public static final SimpleOperationDefinition CONTAINS_NAME_ONLY = new SimpleOperationDefinitionBuilder("contains", ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.ldap.cache"})).setEntryType(OperationEntry.EntryType.PUBLIC).addParameter((AttributeDefinition)NAME_REQUIRED).setRuntimeOnly().setReplyValueType(ModelType.BOOLEAN).build();
    public static final SimpleOperationDefinition CONTAINS_FULL = new SimpleOperationDefinitionBuilder("contains", ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.ldap.cache"})).setEntryType(OperationEntry.EntryType.PUBLIC).addParameter((AttributeDefinition)NAME).addParameter((AttributeDefinition)DISTINGUISHED_NAME).setRuntimeOnly().setReplyValueType(ModelType.BOOLEAN).build();
    private static final OperationStepHandler NAME_ONLY_HANDLER = new NameOnlyOpHandler();
    private static final OperationStepHandler FULL_HANDLER = new FullOpHandler();
    private final SimpleAttributeDefinition[] configurationAttributes;
    private final SimpleAttributeDefinition[] runtimeAttributes;
    private final SimpleOperationDefinition[] runtimeOperations;
    private final OperationStepHandler runtimeStepHandler;

    private LdapCacheResourceDefinition(PathElement pathElement, SimpleAttributeDefinition[] configurationAttributes, SimpleAttributeDefinition[] runtimeAttributes, SimpleOperationDefinition[] runtimeOperations, OperationStepHandler runtimeStepHandler) {
        super(pathElement, ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.ldap.cache"}), (OperationStepHandler)new CacheChildAddHandler((AttributeDefinition[])configurationAttributes), (OperationStepHandler)new SecurityRealmChildRemoveHandler(false), OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
        this.configurationAttributes = configurationAttributes;
        this.runtimeAttributes = runtimeAttributes;
        this.runtimeOperations = runtimeOperations;
        this.runtimeStepHandler = runtimeStepHandler;
    }

    private static ResourceDefinition create(PathElement pathElement, CacheFor cacheFor) {
        OperationStepHandler runtimeHandler;
        SimpleOperationDefinition[] runtimeOperations;
        SimpleAttributeDefinition[] configurationAttributes = new SimpleAttributeDefinition[]{EVICTION_TIME, CACHE_FAILURES, MAX_CACHE_SIZE};
        SimpleAttributeDefinition[] runtimeAttributes = new SimpleAttributeDefinition[]{CACHE_SIZE};
        switch (cacheFor) {
            case AuthUser: {
                runtimeOperations = new SimpleOperationDefinition[]{FLUSH_CACHE_NAME_ONLY, CONTAINS_NAME_ONLY};
                runtimeHandler = NAME_ONLY_HANDLER;
                break;
            }
            default: {
                runtimeOperations = new SimpleOperationDefinition[]{FLUSH_CACHE_FULL, CONTAINS_FULL};
                runtimeHandler = FULL_HANDLER;
            }
        }
        return new LdapCacheResourceDefinition(pathElement, configurationAttributes, runtimeAttributes, runtimeOperations, runtimeHandler);
    }

    public static ResourceDefinition createByAccessTime(CacheFor cacheFor) {
        return LdapCacheResourceDefinition.create(PathElement.pathElement((String)"cache", (String)"by-access-time"), cacheFor);
    }

    public static ResourceDefinition createBySearchTime(CacheFor cacheFor) {
        return LdapCacheResourceDefinition.create(PathElement.pathElement((String)"cache", (String)"by-search-time"), cacheFor);
    }

    private static ModelNode createOperation(ModelNode operationToValidate) {
        PathAddress pa = PathAddress.pathAddress((ModelNode)operationToValidate.require("address"));
        PathAddress validationAddress = pa.subAddress(0, pa.size() - 1);
        return Util.getEmptyOperation((String)"validate-cache", (ModelNode)validationAddress.toModelNode());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        SecurityRealmChildWriteAttributeHandler writeHandler = new SecurityRealmChildWriteAttributeHandler((AttributeDefinition[])this.configurationAttributes);
        for (SimpleAttributeDefinition attr : this.configurationAttributes) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)writeHandler);
        }
        for (SimpleAttributeDefinition attr : this.runtimeAttributes) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)attr, this.runtimeStepHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        for (SimpleOperationDefinition op : this.runtimeOperations) {
            resourceRegistration.registerOperationHandler((OperationDefinition)op, this.runtimeStepHandler);
        }
    }

    private static class CacheDefintionValidatingHandler
    implements OperationStepHandler {
        private CacheDefintionValidatingHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            Set children = resource.getChildrenNames("cache");
            if (children.size() > 1) {
                String realmName = ManagementUtil.getSecurityRealmName(operation);
                throw DomainManagementMessages.MESSAGES.multipleCacheConfigurationsDefined(realmName);
            }
            context.stepCompleted();
        }
    }

    static class CacheChildAddHandler
    extends SecurityRealmChildAddHandler {
        public CacheChildAddHandler(AttributeDefinition[] attributeDefinitions) {
            super(false, false, attributeDefinitions);
        }

        @Override
        protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.updateModel(context, operation);
            ModelNode validateOp = LdapCacheResourceDefinition.createOperation(operation);
            context.addStep(validateOp, (OperationStepHandler)VALIDATION_INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    private static class LdapEntryPredicate
    implements LdapSearcherCache.Predicate<LdapEntry> {
        private final String name;
        private final String distinguishedName;

        private LdapEntryPredicate(String name, String distinguishedName) {
            this.name = name;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public boolean matches(LdapEntry key) {
            if (this.name != null && !this.name.equals(key.getSimpleName())) {
                return false;
            }
            return this.distinguishedName == null || this.distinguishedName.equals(key.getDistinguishedName());
        }
    }

    private static class FullOpHandler
    extends BaseRuntimeOpHandler<LdapEntry> {
        private FullOpHandler() {
        }

        @Override
        public void flushCache(OperationContext context, ModelNode operation) throws OperationFailedException {
            LdapSearcherCache<?, LdapEntry> ldapCacheService = this.lookupService(context, operation);
            String name = null;
            String distinguishedName = null;
            if (operation.hasDefined("name")) {
                name = operation.require("name").asString();
            }
            if (operation.hasDefined("distinguished-name")) {
                distinguishedName = operation.require("distinguished-name").asString();
            }
            if (name == null && distinguishedName == null) {
                ldapCacheService.clearAll();
            } else if (name != null && distinguishedName != null) {
                ldapCacheService.clear(new LdapEntry(name, distinguishedName));
            } else {
                ldapCacheService.clear(new LdapEntryPredicate(name, distinguishedName));
            }
        }

        @Override
        public void contains(OperationContext context, ModelNode operation) throws OperationFailedException {
            LdapSearcherCache<?, LdapEntry> ldapCacheService = this.lookupService(context, operation);
            String name = null;
            String distinguishedName = null;
            if (operation.hasDefined("name")) {
                name = operation.require("name").asString();
            }
            if (operation.hasDefined("distinguished-name")) {
                distinguishedName = operation.require("distinguished-name").asString();
            }
            if (name == null && distinguishedName == null) {
                context.getResult().set(false);
            } else if (name != null && distinguishedName != null) {
                context.getResult().set(ldapCacheService.contains(new LdapEntry(name, distinguishedName)));
            } else {
                boolean contains = ldapCacheService.count(new LdapEntryPredicate(name, distinguishedName)) > 0;
                context.getResult().set(contains);
            }
        }
    }

    private static class NameOnlyOpHandler
    extends BaseRuntimeOpHandler<String> {
        private NameOnlyOpHandler() {
        }

        @Override
        public void flushCache(OperationContext context, ModelNode operation) throws OperationFailedException {
            LdapSearcherCache<?, String> ldapCacheService = this.lookupService(context, operation);
            if (operation.hasDefined("name")) {
                String name = operation.require("name").asString();
                ldapCacheService.clear(name);
            } else {
                ldapCacheService.clearAll();
            }
        }

        @Override
        public void contains(OperationContext context, ModelNode operation) throws OperationFailedException {
            LdapSearcherCache<?, String> ldapCacheService = this.lookupService(context, operation);
            String name = operation.require("name").asString();
            context.getResult().set(ldapCacheService.contains(name));
        }
    }

    private static abstract class BaseRuntimeOpHandler<K>
    implements OperationStepHandler {
        private static final Set<String> VALID_OPS;

        private BaseRuntimeOpHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final String operationName = operation.get("operation").asString();
            if (VALID_OPS.contains(operationName)) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        if ("read-attribute".equals(operationName)) {
                            BaseRuntimeOpHandler.this.readAttribute(context, operation);
                        } else if ("flush-cache".equals(operationName)) {
                            BaseRuntimeOpHandler.this.flushCache(context, operation);
                        } else if ("contains".equals(operationName)) {
                            BaseRuntimeOpHandler.this.contains(context, operation);
                        }
                        context.stepCompleted();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.stepCompleted();
        }

        public abstract void flushCache(OperationContext var1, ModelNode var2) throws OperationFailedException;

        public abstract void contains(OperationContext var1, ModelNode var2) throws OperationFailedException;

        public void readAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String name = operation.get("name").asString();
            if ("cache-size".equals(name)) {
                LdapSearcherCache<?, K> ldapCacheService = this.lookupService(context, operation);
                context.getResult().set(ldapCacheService.getCurrentSize());
            }
        }

        protected LdapSearcherCache<?, K> lookupService(OperationContext context, ModelNode operation) throws OperationFailedException {
            String realmName = null;
            boolean forAuthentication = false;
            boolean forUserSearch = false;
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            for (PathElement current : address) {
                String key = current.getKey();
                if ("security-realm".equals(key)) {
                    realmName = current.getValue();
                    continue;
                }
                if ("authentication".equals(key)) {
                    forAuthentication = true;
                    forUserSearch = true;
                    continue;
                }
                if ("authorization".equals(key)) {
                    forAuthentication = false;
                    continue;
                }
                if ("username-to-dn".equals(key)) {
                    forUserSearch = true;
                    continue;
                }
                if (!"group-search".equals(key)) continue;
                forUserSearch = false;
            }
            ServiceName serviceName = LdapSearcherCache.ServiceUtil.createServiceName(forAuthentication, forUserSearch, realmName);
            ServiceRegistry registry = context.getServiceRegistry(true);
            ServiceController service = registry.getRequiredService(serviceName);
            try {
                return (LdapSearcherCache)service.awaitValue();
            }
            catch (InterruptedException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        static {
            HashSet<String> ops = new HashSet<String>(3);
            ops.add("read-attribute");
            ops.add("flush-cache");
            ops.add("contains");
            VALID_OPS = Collections.unmodifiableSet(ops);
        }
    }

    public static enum CacheFor {
        AuthUser,
        AuthzUser,
        AuthzGroup;

    }
}

