/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.AuthorizationValidatingHandler;
import org.jboss.as.domain.management.security.SecurityRealmParentRestartHandler;
import org.jboss.dmr.ModelNode;

public class SecurityRealmChildAddHandler
extends SecurityRealmParentRestartHandler {
    private final boolean validateAuthentication;
    private final boolean validateAuthorization;
    private final AttributeDefinition[] attributeDefinitions;

    public SecurityRealmChildAddHandler(boolean validateAuthentication, boolean validateAuthorization, AttributeDefinition ... attributeDefinitions) {
        this.validateAuthentication = validateAuthentication;
        this.validateAuthorization = validateAuthorization;
        this.attributeDefinitions = attributeDefinitions == null ? new AttributeDefinition[]{} : attributeDefinitions;
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attr : this.attributeDefinitions) {
            attr.validateAndSet(operation, model);
        }
        if (!context.isBooting()) {
            ModelNode validationOp;
            if (this.validateAuthentication) {
                validationOp = AuthenticationValidatingHandler.createOperation(operation);
                context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
            }
            if (this.validateAuthorization) {
                validationOp = AuthorizationValidatingHandler.createOperation(operation);
                context.addStep(validationOp, (OperationStepHandler)AuthorizationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
            }
        }
    }
}

