/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.keycloak.common.Version;

public class Profile {
    private static final Profile CURRENT = new Profile();
    private final ProductValue product;
    private final ProfileValue profile;
    private final Set<Feature> disabledFeatures = new HashSet<Feature>();

    private Profile() {
        this.product = "rh-sso".equals(Version.NAME) ? ProductValue.RHSSO : ProductValue.KEYCLOAK;
        try {
            File file;
            Properties props = new Properties();
            String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
            if (jbossServerConfigDir != null && (file = new File(jbossServerConfigDir, "profile.properties")).isFile()) {
                props.load(new FileInputStream(file));
            }
            if (System.getProperties().containsKey("keycloak.profile")) {
                props.setProperty("profile", System.getProperty("keycloak.profile"));
            }
            for (String k : System.getProperties().stringPropertyNames()) {
                if (!k.startsWith("keycloak.profile.feature.")) continue;
                props.put(k.replace("keycloak.profile.feature.", "feature."), System.getProperty(k));
            }
            this.profile = props.containsKey("profile") ? ProfileValue.valueOf(props.getProperty("profile").toUpperCase()) : ProfileValue.valueOf(Version.DEFAULT_PROFILE.toUpperCase());
            this.disabledFeatures.addAll(this.profile.disabled);
            this.disabledFeatures.removeAll(this.product.excluded);
            for (String k : props.stringPropertyNames()) {
                if (!k.startsWith("feature.")) continue;
                Feature f = Feature.valueOf(k.replace("feature.", "").toUpperCase());
                if (props.get(k).equals("enabled")) {
                    this.disabledFeatures.remove((Object)f);
                    continue;
                }
                if (!props.get(k).equals("disabled")) continue;
                this.disabledFeatures.add(f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getName() {
        return Profile.CURRENT.profile.name().toLowerCase();
    }

    public static Set<Feature> getDisabledFeatures() {
        return Profile.CURRENT.disabledFeatures;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        if (Profile.CURRENT.product.excluded.contains((Object)feature)) {
            return false;
        }
        return !Profile.CURRENT.disabledFeatures.contains((Object)feature);
    }

    private static enum ProfileValue {
        PRODUCT(Feature.ADMIN_FINE_GRAINED_AUTHZ, Feature.SCRIPTS, Feature.DOCKER, Feature.ACCOUNT2, Feature.TOKEN_EXCHANGE),
        PREVIEW(Feature.ACCOUNT2),
        COMMUNITY(Feature.DOCKER, Feature.ACCOUNT2);

        private List<Feature> disabled;

        private ProfileValue(Feature ... disabled) {
            this.disabled = Arrays.asList(disabled);
        }
    }

    private static enum ProductValue {
        KEYCLOAK(new Feature[0]),
        RHSSO(Feature.ACCOUNT2);

        private List<Feature> excluded;

        private ProductValue(Feature ... excluded) {
            this.excluded = Arrays.asList(excluded);
        }
    }

    public static enum Feature {
        ACCOUNT2,
        ADMIN_FINE_GRAINED_AUTHZ,
        DOCKER,
        IMPERSONATION,
        OPENSHIFT_INTEGRATION,
        SCRIPTS,
        TOKEN_EXCHANGE;

    }
}

