/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ResourceMetadata;
import org.keycloak.adapters.as7.AuthenticatedActionsValve;
import org.keycloak.adapters.as7.CatalinaBearerTokenAuthenticator;
import org.keycloak.adapters.as7.CorsPreflightChecker;
import org.keycloak.adapters.as7.config.CatalinaManagedResourceConfigLoader;
import org.keycloak.adapters.config.ManagedResourceConfig;

public class BearerTokenAuthenticatorValve
extends AuthenticatorBase
implements LifecycleListener {
    private static final Logger log = Logger.getLogger(BearerTokenAuthenticatorValve.class);
    protected ManagedResourceConfig remoteSkeletonKeyConfig;
    protected ResourceMetadata resourceMetadata;

    public void start() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            this.init();
        }
    }

    protected void init() {
        CatalinaManagedResourceConfigLoader managedResourceConfigLoader = new CatalinaManagedResourceConfigLoader(this.context);
        this.remoteSkeletonKeyConfig = managedResourceConfigLoader.getRemoteSkeletonKeyConfig();
        managedResourceConfigLoader.init(false);
        this.resourceMetadata = managedResourceConfigLoader.getResourceMetadata();
        AuthenticatedActionsValve actions = new AuthenticatedActionsValve(this.remoteSkeletonKeyConfig, this.getNext(), this.getContainer(), this.getController());
        this.setNext((Valve)actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            log.debugv("{0} {1}", (Object)request.getMethod(), (Object)request.getRequestURI());
            if (this.remoteSkeletonKeyConfig.isCors() && new CorsPreflightChecker(this.remoteSkeletonKeyConfig).checkCorsPreflight(request, response)) {
                return;
            }
            super.invoke(request, response);
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    protected boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        try {
            CatalinaBearerTokenAuthenticator bearer = new CatalinaBearerTokenAuthenticator(this.resourceMetadata, true, this.remoteSkeletonKeyConfig.isUseResourceRoleMappings());
            return bearer.login(request, response);
        }
        catch (LoginException e) {
            return false;
        }
    }
}

