/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.io.IOException;
import java.util.Set;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.keycloak.SkeletonKeySession;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class AuthenticatedActionsValve
extends ValveBase {
    private static final Logger log = Logger.getLogger(AuthenticatedActionsValve.class);
    protected AdapterConfig config;

    public AuthenticatedActionsValve(AdapterConfig config, Valve next, Container container, ObjectName controller) {
        this.config = config;
        if (next == null) {
            throw new RuntimeException("WTF is next null?!");
        }
        this.setNext(next);
        this.setContainer(container);
        this.setController(controller);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        log.debugv("AuthenticatedActionsValve.invoke {0}", (Object)request.getRequestURI());
        SkeletonKeySession session = this.getSkeletonKeySession(request);
        if (this.corsRequest(request, response, session)) {
            return;
        }
        String requestUri = request.getRequestURI();
        if (requestUri.endsWith("k_query_bearer_token")) {
            this.queryBearerToken(request, response, session);
            return;
        }
        this.getNext().invoke(request, response);
    }

    public SkeletonKeySession getSkeletonKeySession(Request request) {
        SkeletonKeySession skSession = (SkeletonKeySession)request.getAttribute(SkeletonKeySession.class.getName());
        if (skSession != null) {
            return skSession;
        }
        Session session = request.getSessionInternal();
        if (session != null) {
            return (SkeletonKeySession)session.getNote(SkeletonKeySession.class.getName());
        }
        return null;
    }

    protected void queryBearerToken(Request request, Response response, SkeletonKeySession session) throws IOException, ServletException {
        log.debugv("queryBearerToken {0}", (Object)request.getRequestURI());
        if (this.abortTokenResponse(request, response, session)) {
            return;
        }
        response.setStatus(200);
        response.setContentType("text/plain");
        response.getOutputStream().write(session.getTokenString().getBytes());
        response.getOutputStream().flush();
    }

    protected boolean abortTokenResponse(Request request, Response response, SkeletonKeySession session) throws IOException {
        if (session == null) {
            log.debugv("session was null, sending back 401: {0}", (Object)request.getRequestURI());
            response.sendError(401);
            return true;
        }
        if (!this.config.isExposeToken()) {
            response.setStatus(200);
            return true;
        }
        if (!this.config.isCors() && request.getHeader("Origin") != null) {
            response.setStatus(200);
            return true;
        }
        return false;
    }

    protected boolean corsRequest(Request request, Response response, SkeletonKeySession session) throws IOException {
        if (!this.config.isCors()) {
            return false;
        }
        log.debugv("CORS enabled + request.getRequestURI()", new Object[0]);
        String origin = request.getHeader("Origin");
        log.debugv("Origin: {0} uri: {1}", (Object)origin, (Object)request.getRequestURI());
        if (session != null && origin != null) {
            SkeletonKeyToken token = session.getToken();
            Set allowedOrigins = token.getAllowedOrigins();
            if (log.isDebugEnabled()) {
                for (String a : allowedOrigins) {
                    log.debug((Object)("   " + a));
                }
            }
            if (allowedOrigins == null || !allowedOrigins.contains("*") && !allowedOrigins.contains(origin)) {
                if (allowedOrigins == null) {
                    log.debugv("allowedOrigins was null in token", new Object[0]);
                }
                if (!allowedOrigins.contains("*") && !allowedOrigins.contains(origin)) {
                    log.debugv("allowedOrigins did not contain origin", new Object[0]);
                }
                response.sendError(403);
                return true;
            }
            log.debugv("returning origin: {0}", (Object)origin);
            response.setHeader("Access-Control-Allow-Origin", origin);
            response.setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            log.debugv("session or origin was null: {0}", (Object)request.getRequestURI());
        }
        return false;
    }
}

