/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.PublicKey;
import java.util.HashSet;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.keycloak.SkeletonKeyPrincipal;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.ResourceMetadata;
import org.keycloak.adapters.as7.AuthenticatedActionsValve;
import org.keycloak.adapters.as7.CatalinaBearerTokenAuthenticator;
import org.keycloak.adapters.as7.CatalinaSecurityContextHelper;
import org.keycloak.adapters.as7.CorsPreflightChecker;
import org.keycloak.adapters.as7.ServletOAuthLogin;
import org.keycloak.adapters.as7.UserSessionManagement;
import org.keycloak.adapters.as7.config.CatalinaAdapterConfigLoader;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.StreamUtil;

public class KeycloakAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    protected RealmConfiguration realmConfiguration;
    private static final Logger log = Logger.getLogger(KeycloakAuthenticatorValve.class);
    protected UserSessionManagement userSessionManagement = new UserSessionManagement();
    protected AdapterConfig adapterConfig;
    protected ResourceMetadata resourceMetadata;

    public void start() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            this.init();
        }
    }

    protected void init() {
        CatalinaAdapterConfigLoader configLoader = new CatalinaAdapterConfigLoader(this.context);
        configLoader.init(true);
        this.resourceMetadata = configLoader.getResourceMetadata();
        this.adapterConfig = configLoader.getAdapterConfig();
        this.realmConfiguration = configLoader.getRealmConfiguration();
        AuthenticatedActionsValve actions = new AuthenticatedActionsValve(this.adapterConfig, this.getNext(), this.getContainer(), this.getController());
        this.setNext((Valve)actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.adapterConfig.isCors() && new CorsPreflightChecker(this.adapterConfig).checkCorsPreflight(request, response)) {
            return;
        }
        String requestURI = request.getDecodedRequestURI();
        if (requestURI.endsWith("k_logout")) {
            JWSInput input = this.verifyAdminRequest((HttpServletRequest)request, (HttpServletResponse)response);
            if (input == null) {
                return;
            }
            this.remoteLogout(input, (HttpServletResponse)response);
            return;
        }
        super.invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        try {
            if (this.bearer(false, request, response)) {
                return true;
            }
            if (this.checkLoggedIn(request, response)) {
                if (request.getSessionInternal().getNote("org.apache.catalina.authenticator.REQUEST") != null) {
                    if (this.restoreRequest(request, request.getSessionInternal())) {
                        log.debug((Object)"restoreRequest");
                        return true;
                    }
                    log.debug((Object)"Restore of original request failed");
                    response.sendError(400);
                    return false;
                }
                return true;
            }
            if (!this.adapterConfig.isBearerOnly()) {
                this.oauth(request, response);
            }
        }
        catch (LoginException e) {
            // empty catch block
        }
        return false;
    }

    protected JWSInput verifyAdminRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = StreamUtil.readString((InputStream)request.getInputStream());
        if (token == null) {
            log.warn((Object)"admin request failed, no token");
            response.sendError(403, "no token");
            return null;
        }
        JWSInput input = new JWSInput(token);
        boolean verified = false;
        try {
            verified = RSAProvider.verify((JWSInput)input, (PublicKey)this.resourceMetadata.getRealmKey());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (!verified) {
            log.warn((Object)"admin request failed, unable to verify token");
            response.sendError(403, "verification failed");
            return null;
        }
        return input;
    }

    protected void remoteLogout(JWSInput token, HttpServletResponse response) throws IOException {
        try {
            log.debug((Object)"->> remoteLogout: ");
            LogoutAction action = (LogoutAction)JsonSerialization.readValue((byte[])token.getContent(), LogoutAction.class);
            if (action.isExpired()) {
                log.warn((Object)"admin request failed, expired token");
                response.sendError(400, "Expired token");
                return;
            }
            if (!this.resourceMetadata.getResourceName().equals(action.getResource())) {
                log.warn((Object)"Resource name does not match");
                response.sendError(400, "Resource name does not match");
                return;
            }
            String user = action.getUser();
            if (user != null) {
                log.debug((Object)("logout of session for: " + user));
                this.userSessionManagement.logout(user);
            } else {
                log.debug((Object)"logout of all sessions");
                this.userSessionManagement.logoutAll();
            }
        }
        catch (Exception e) {
            log.warn((Object)"failed to logout", (Throwable)e);
            response.sendError(500, "Failed to logout");
        }
        response.setStatus(204);
    }

    protected boolean bearer(boolean challenge, Request request, HttpServletResponse response) throws LoginException, IOException {
        boolean useResourceRoleMappings = this.adapterConfig.isUseResourceRoleMappings();
        CatalinaBearerTokenAuthenticator bearer = new CatalinaBearerTokenAuthenticator(this.resourceMetadata, challenge, useResourceRoleMappings);
        return bearer.login(request, response);
    }

    protected boolean checkLoggedIn(Request request, HttpServletResponse response) {
        SkeletonKeySession skSession;
        if (request.getSessionInternal() == null || request.getSessionInternal().getPrincipal() == null) {
            return false;
        }
        log.debug((Object)"remote logged in already");
        GenericPrincipal principal = (GenericPrincipal)request.getSessionInternal().getPrincipal();
        request.setUserPrincipal((Principal)principal);
        request.setAuthType("OAUTH");
        Session session = request.getSessionInternal();
        if (session != null && (skSession = (SkeletonKeySession)session.getNote(SkeletonKeySession.class.getName())) != null) {
            request.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
        }
        return true;
    }

    protected void oauth(Request request, HttpServletResponse response) throws IOException {
        SkeletonKeyToken.Access access;
        ServletOAuthLogin oauth = new ServletOAuthLogin(this.realmConfiguration, (HttpServletRequest)request, response, request.getConnector().getRedirectPort());
        String code = oauth.getCode();
        if (code == null) {
            String error = oauth.getError();
            if (error != null) {
                response.sendError(400, "OAuth " + error);
                return;
            }
            this.saveRequest(request, request.getSessionInternal(true));
            oauth.loginRedirect();
            return;
        }
        if (!oauth.resolveCode(code)) {
            return;
        }
        SkeletonKeyToken token = oauth.getToken();
        HashSet<String> roles = new HashSet<String>();
        if (this.adapterConfig.isUseResourceRoleMappings()) {
            access = token.getResourceAccess(this.resourceMetadata.getResourceName());
            if (access != null) {
                roles.addAll(access.getRoles());
            }
        } else {
            access = token.getRealmAccess();
            if (access != null) {
                roles.addAll(access.getRoles());
            }
        }
        SkeletonKeyPrincipal skp = new SkeletonKeyPrincipal(token.getSubject(), null);
        GenericPrincipal principal = new CatalinaSecurityContextHelper().createPrincipal(this.context.getRealm(), (Principal)skp, roles);
        Session session = request.getSessionInternal(true);
        session.setPrincipal((Principal)principal);
        session.setAuthType("OAUTH");
        SkeletonKeySession skSession = new SkeletonKeySession(oauth.getTokenString(), token, this.realmConfiguration.getMetadata());
        session.setNote(SkeletonKeySession.class.getName(), (Object)skSession);
        String username = token.getSubject();
        log.debug((Object)("userSessionManage.login: " + username));
        this.userSessionManagement.login(session, username);
    }
}

