/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7.config;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.jboss.logging.Logger;
import org.keycloak.adapters.config.RealmConfigurationLoader;

public class CatalinaAdapterConfigLoader
extends RealmConfigurationLoader {
    private static final Logger log = Logger.getLogger(CatalinaAdapterConfigLoader.class);

    private InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        log.info((Object)"**** using org.keycloak.json.adapterConfig");
        log.info((Object)json);
        return new ByteArrayInputStream(json.getBytes());
    }

    public CatalinaAdapterConfigLoader(Context context) {
        log.info((Object)"******* Loading adapter config.");
        InputStream is = this.getJSONFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.info((Object)"**** using /WEB-INF/keycloak.json");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (is == null) {
            throw new RuntimeException("Could not find keycloak config.");
        }
        this.loadConfig(is);
    }
}

