/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.io.IOException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.as7.CatalinaHttpFacade;

public class AuthenticatedActionsValve
extends ValveBase {
    private static final Logger log = Logger.getLogger(AuthenticatedActionsValve.class);
    protected AdapterDeploymentContext deploymentContext;

    public AuthenticatedActionsValve(AdapterDeploymentContext deploymentContext, Valve next, Container container, ObjectName controller) {
        this.deploymentContext = deploymentContext;
        if (next == null) {
            throw new RuntimeException("Next valve is null!!!");
        }
        this.setNext(next);
        this.setContainer(container);
        this.setController(controller);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        AuthenticatedActionsHandler handler;
        log.debugv("AuthenticatedActionsValve.invoke {0}", (Object)request.getRequestURI());
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, (HttpServletResponse)response);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment != null && deployment.isConfigured() && (handler = new AuthenticatedActionsHandler(deployment, (HttpFacade)new CatalinaHttpFacade(request, (HttpServletResponse)response))).handledRequest()) {
            return;
        }
        this.getNext().invoke(request, response);
    }
}

