/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.email;

import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventType;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class EmailAuditListener
implements AuditListener {
    private static final Logger log = Logger.getLogger(EmailAuditListener.class);
    private KeycloakSession keycloakSession;
    private EmailProvider emailProvider;
    private Set<EventType> includedEvents;

    public EmailAuditListener(KeycloakSession keycloakSession, EmailProvider emailProvider, Set<EventType> includedEvents) {
        this.keycloakSession = keycloakSession;
        this.emailProvider = emailProvider;
        this.includedEvents = includedEvents;
    }

    public void onEvent(Event event) {
        RealmModel realm;
        UserModel user;
        if (this.includedEvents.contains(event.getEvent()) && event.getRealmId() != null && event.getUserId() != null && (user = (realm = this.keycloakSession.getRealm(event.getRealmId())).getUserById(event.getUserId())) != null && user.getEmail() != null && user.isEmailVerified()) {
            try {
                this.emailProvider.setRealm(realm).setUser(user).sendEvent(event);
            }
            catch (EmailException e) {
                log.error((Object)"Failed to send event mail", (Throwable)e);
            }
        }
    }

    public void close() {
    }
}

