/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.concurrent.Callable;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.HttpMethod;
import org.keycloak.authorization.client.util.HttpMethodResponse;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;

public class AuthorizationResource {
    private Configuration configuration;
    private ServerConfiguration serverConfiguration;
    private Http http;
    private TokenCallable token;

    public AuthorizationResource(Configuration configuration, ServerConfiguration serverConfiguration, Http http, TokenCallable token) {
        this.configuration = configuration;
        this.serverConfiguration = serverConfiguration;
        this.http = http;
        this.token = token;
    }

    public AuthorizationResponse authorize() throws AuthorizationDeniedException {
        return this.authorize(new AuthorizationRequest());
    }

    public AuthorizationResponse authorize(AuthorizationRequest request) throws AuthorizationDeniedException {
        return this.invoke(request, new TypeReference<AuthorizationResponse>(){});
    }

    public List<Permission> getPermissions(AuthorizationRequest request) throws AuthorizationDeniedException {
        AuthorizationRequest.Metadata metadata;
        if (request.getMetadata() == null) {
            metadata = new AuthorizationRequest.Metadata();
            request.setMetadata(metadata);
        } else {
            metadata = request.getMetadata();
        }
        metadata.setResponseMode("permissions");
        return this.invoke(request, new TypeReference<List<Permission>>(){});
    }

    private <T> T invoke(final AuthorizationRequest request, final TypeReference<T> responseType) {
        if (request == null) {
            throw new IllegalArgumentException("Authorization request must not be null");
        }
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (request.getAudience() == null) {
                    request.setAudience(AuthorizationResource.this.configuration.getResource());
                }
                HttpMethod method = AuthorizationResource.this.http.post(AuthorizationResource.this.serverConfiguration.getTokenEndpoint());
                if (AuthorizationResource.this.token != null) {
                    method = method.authorizationBearer(AuthorizationResource.this.token.call());
                }
                HttpMethodResponse response = method.authentication().uma(request).response().json(responseType);
                return response.execute();
            }
        };
        try {
            return (T)callable.call();
        }
        catch (Exception cause) {
            return (T)Throwables.retryAndWrapExceptionIfNecessary(callable, this.token, "Failed to obtain authorization data", cause);
        }
    }
}

