/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.clientscope;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.clientscope.ClientScopePolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.authorization.ClientScopePolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class ClientScopePolicyProviderFactory
implements PolicyProviderFactory<ClientScopePolicyRepresentation> {
    private ClientScopePolicyProvider provider = new ClientScopePolicyProvider(this::toRepresentation);

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof ClientScopeModel.ClientScopeRemovedEvent) {
                KeycloakSession keycloakSession = ((ClientScopeModel.ClientScopeRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                StoreFactory storeFactory = provider.getStoreFactory();
                final PolicyStore policyStore = storeFactory.getPolicyStore();
                final ClientScopeModel removedClientScope = ((ClientScopeModel.ClientScopeRemovedEvent)event).getClientScope();
                HashMap<Policy.FilterOption, String[]> filters = new HashMap<Policy.FilterOption, String[]>();
                filters.put(Policy.FilterOption.TYPE, new String[]{this.getId()});
                policyStore.findByResourceServer(filters, null, -1, -1).forEach(new Consumer<Policy>(){

                    @Override
                    public void accept(Policy policy) {
                        ArrayList clientScopes = new ArrayList();
                        for (Map clientScope : ClientScopePolicyProviderFactory.this.getClientScopes(policy)) {
                            if (clientScope.get("id").equals(removedClientScope.getId())) continue;
                            HashMap updated = new HashMap();
                            updated.put("id", clientScope.get("id"));
                            Object required = clientScope.get("required");
                            if (required != null) {
                                updated.put("required", required);
                            }
                            clientScopes.add(updated);
                        }
                        if (clientScopes.isEmpty()) {
                            policyStore.delete(policy.getId());
                        } else {
                            try {
                                policy.putConfig("clientScopes", JsonSerialization.writeValueAsString(clientScopes));
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Error while synchronizing client scopes with policy [" + policy.getName() + "].", e);
                            }
                        }
                    }
                });
            }
        });
    }

    private Map<String, Object>[] getClientScopes(Policy policy) {
        String clientScopes = (String)policy.getConfig().get("clientScopes");
        if (clientScopes != null) {
            try {
                return (Map[])JsonSerialization.readValue((byte[])clientScopes.getBytes(), Map[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse client scopes [" + clientScopes + "] from policy config [" + policy.getName() + "].", e);
            }
        }
        return new Map[0];
    }

    public void close() {
    }

    public String getId() {
        return "client-scope";
    }

    public String getName() {
        return "Client Scope";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public ClientScopePolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        ClientScopePolicyRepresentation representation = new ClientScopePolicyRepresentation();
        try {
            representation.setClientScopes(new HashSet<Object>(Arrays.asList((Object[])JsonSerialization.readValue((String)((String)policy.getConfig().get("clientScopes")), ClientScopePolicyRepresentation.ClientScopeDefinition[].class))));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize client scopes", e);
        }
        return representation;
    }

    public Class<ClientScopePolicyRepresentation> getRepresentationType() {
        return ClientScopePolicyRepresentation.class;
    }

    public void onCreate(Policy policy, ClientScopePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateClientScopes(policy, representation, authorization);
    }

    public void onUpdate(Policy policy, ClientScopePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateClientScopes(policy, representation, authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        try {
            this.updateClientScopes(policy, authorization, new HashSet<Object>(Arrays.asList((Object[])JsonSerialization.readValue((String)((String)representation.getConfig().get("clientScopes")), ClientScopePolicyRepresentation.ClientScopeDefinition[].class))));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize client scopes during import", e);
        }
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorizationProvider) {
        HashMap<String, String> config = new HashMap<String, String>();
        Set clientScopes = this.toRepresentation(policy, authorizationProvider).getClientScopes();
        for (ClientScopePolicyRepresentation.ClientScopeDefinition clientScopeDefinition : clientScopes) {
            ClientScopeModel clientScope = authorizationProvider.getRealm().getClientScopeById(clientScopeDefinition.getId());
            clientScopeDefinition.setId(clientScope.getName());
        }
        try {
            config.put("clientScopes", JsonSerialization.writeValueAsString((Object)clientScopes));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to export client scope policy [" + policy.getName() + "]", e);
        }
        representation.setConfig(config);
    }

    private void updateClientScopes(Policy policy, ClientScopePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateClientScopes(policy, authorization, representation.getClientScopes());
    }

    private void updateClientScopes(Policy policy, AuthorizationProvider authorization, Set<ClientScopePolicyRepresentation.ClientScopeDefinition> clientScopes) {
        RealmModel realm = authorization.getRealm();
        HashSet<ClientScopePolicyRepresentation.ClientScopeDefinition> updatedClientScopes = new HashSet<ClientScopePolicyRepresentation.ClientScopeDefinition>();
        if (clientScopes != null) {
            for (ClientScopePolicyRepresentation.ClientScopeDefinition definition : clientScopes) {
                String clientScopeName = definition.getId();
                ClientScopeModel clientScope = realm.getClientScopesStream().filter(scope -> scope.getName().equals(clientScopeName)).findAny().orElse(null);
                if (clientScope == null) {
                    clientScope = realm.getClientScopeById(clientScopeName);
                }
                if (clientScope == null) {
                    throw new RuntimeException("Error while updating policy [" + policy.getName() + "]. Client Scope [] could not be found.");
                }
                definition.setId(clientScope.getId());
                updatedClientScopes.add(definition);
            }
        }
        try {
            policy.putConfig("clientScopes", JsonSerialization.writeValueAsString(updatedClientScopes));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize client scopes", e);
        }
    }
}

