/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.regex;

import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.representations.idm.authorization.RegexPolicyRepresentation;

public class RegexPolicyProvider
implements PolicyProvider {
    private final BiFunction<Policy, AuthorizationProvider, RegexPolicyRepresentation> representationFunction;

    public RegexPolicyProvider(BiFunction<Policy, AuthorizationProvider, RegexPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void close() {
    }

    public void evaluate(Evaluation evaluation) {
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RegexPolicyRepresentation policy = this.representationFunction.apply(evaluation.getPolicy(), authorizationProvider);
        Attributes.Entry targetClaim = evaluation.getContext().getIdentity().getAttributes().getValue(policy.getTargetClaim());
        if (targetClaim == null) {
            return;
        }
        Pattern pattern = Pattern.compile(policy.getPattern());
        Matcher matcher = pattern.matcher(targetClaim.asString(0));
        if (matcher.matches()) {
            evaluation.grant();
        }
    }
}

