/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.aggregated;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;

public class AggregatePolicyAdminResource
implements PolicyProviderAdminService {
    private final ResourceServer resourceServer;

    public AggregatePolicyAdminResource(ResourceServer resourceServer) {
        this.resourceServer = resourceServer;
    }

    public void onCreate(Policy policy) {
        this.verifyCircularReference(policy, new ArrayList<String>());
    }

    public void onUpdate(Policy policy) {
        this.verifyCircularReference(policy, new ArrayList<String>());
    }

    private void verifyCircularReference(Policy policy, List<String> ids) {
        if (!policy.getType().equals("aggregate")) {
            return;
        }
        if (ids.contains(policy.getId())) {
            throw new RuntimeException("Circular reference found [" + policy.getName() + "].");
        }
        ids.add(policy.getId());
        for (Policy associated : policy.getAssociatedPolicies()) {
            this.verifyCircularReference(associated, ids);
        }
    }

    public void onRemove(Policy policy) {
    }
}

