/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.aggregated;

import java.util.List;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;

public class AggregatePolicyProvider
implements PolicyProvider {
    private final Policy policy;
    private final AuthorizationProvider authorization;

    public AggregatePolicyProvider(Policy policy, AuthorizationProvider authorization) {
        this.policy = policy;
        this.authorization = authorization;
    }

    public void evaluate(final Evaluation evaluation) {
        DecisionResultCollector decision = new DecisionResultCollector(){

            protected void onComplete(List<Result> results) {
                if (results.isEmpty()) {
                    evaluation.deny();
                } else {
                    Result result = results.iterator().next();
                    if (Decision.Effect.PERMIT.equals((Object)result.getEffect())) {
                        evaluation.grant();
                    }
                }
            }
        };
        this.policy.getAssociatedPolicies().forEach(associatedPolicy -> {
            PolicyProviderFactory providerFactory = this.authorization.getProviderFactory(associatedPolicy.getType());
            PolicyProvider policyProvider = providerFactory.create(associatedPolicy, this.authorization);
            policyProvider.evaluate((Evaluation)new DefaultEvaluation(evaluation.getPermission(), evaluation.getContext(), this.policy, associatedPolicy, (Decision)decision));
        });
        decision.onComplete();
    }

    public void close() {
    }
}

