/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.role.RolePolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.util.JsonSerialization;

public class RolePolicyProviderFactory
implements PolicyProviderFactory {
    private RolePolicyProvider provider = new RolePolicyProvider();

    public String getName() {
        return "Role";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer) {
        return null;
    }

    public PolicyProvider create(KeycloakSession session) {
        return new RolePolicyProvider();
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RoleContainerModel.RoleRemovedEvent) {
                KeycloakSession keycloakSession = ((RoleContainerModel.RoleRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                StoreFactory storeFactory = provider.getStoreFactory();
                PolicyStore policyStore = storeFactory.getPolicyStore();
                RoleModel removedRole = ((RoleContainerModel.RoleRemovedEvent)event).getRole();
                RoleContainerModel container = removedRole.getContainer();
                ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
                if (container instanceof RealmModel) {
                    RealmModel realm = (RealmModel)container;
                    realm.getClients().forEach(clientModel -> this.updateResourceServer((ClientModel)clientModel, removedRole, resourceServerStore, policyStore));
                } else {
                    ClientModel clientModel2 = (ClientModel)container;
                    this.updateResourceServer(clientModel2, removedRole, resourceServerStore, policyStore);
                }
            }
        });
    }

    private void updateResourceServer(ClientModel clientModel, RoleModel removedRole, ResourceServerStore resourceServerStore, PolicyStore policyStore) {
        ResourceServer resourceServer = resourceServerStore.findByClient(clientModel.getId());
        if (resourceServer != null) {
            policyStore.findByType(this.getId(), resourceServer.getId()).forEach(policy -> {
                ArrayList roles = new ArrayList();
                for (Map<String, Object> role : RolePolicyProviderFactory.getRoles(policy)) {
                    if (role.get("id").equals(removedRole.getId())) continue;
                    HashMap<String, Object> updated = new HashMap<String, Object>();
                    updated.put("id", role.get("id"));
                    Object required = role.get("required");
                    if (required != null) {
                        updated.put("required", required);
                    }
                    roles.add(updated);
                }
                try {
                    if (roles.isEmpty()) {
                        policyStore.findDependentPolicies(policy.getId(), resourceServer.getId()).forEach(dependentPolicy -> {
                            dependentPolicy.removeAssociatedPolicy(policy);
                            if (dependentPolicy.getAssociatedPolicies().isEmpty()) {
                                policyStore.delete(dependentPolicy.getId());
                            }
                        });
                        policyStore.delete(policy.getId());
                    } else {
                        Map config = policy.getConfig();
                        config.put("roles", JsonSerialization.writeValueAsString(roles));
                        policy.setConfig(config);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while synchronizing roles with policy [" + policy.getName() + "].", e);
                }
            });
        }
    }

    public void close() {
    }

    public String getId() {
        return "role";
    }

    static Map<String, Object>[] getRoles(Policy policy) {
        String roles = (String)policy.getConfig().get("roles");
        if (roles != null) {
            try {
                return (Map[])JsonSerialization.readValue((byte[])roles.getBytes(), Map[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse roles [" + roles + "] from policy config [" + policy.getName() + ".", e);
            }
        }
        return new Map[0];
    }
}

