/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.client;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.client.ClientPolicyProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public class ClientPolicyProvider
implements PolicyProvider {
    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        EvaluationContext context = evaluation.getContext();
        String[] clients = ClientPolicyProviderFactory.getClients(policy);
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RealmModel realm = authorizationProvider.getKeycloakSession().getContext().getRealm();
        if (clients.length > 0) {
            for (String client : clients) {
                ClientModel clientModel = realm.getClientById(client);
                if (!context.getAttributes().containsValue("kc.client.id", clientModel.getClientId())) continue;
                evaluation.grant();
                return;
            }
        }
    }

    public void close() {
    }
}

