/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.js;

import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.js.JSPolicyProvider;
import org.keycloak.authorization.policy.provider.js.ScriptCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScriptModel;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.scripting.EvaluatableScriptAdapter;
import org.keycloak.scripting.ScriptingProvider;

public class JSPolicyProviderFactory
implements PolicyProviderFactory<JSPolicyRepresentation> {
    private final JSPolicyProvider provider = new JSPolicyProvider(this::getEvaluatableScript);
    private ScriptCache scriptCache;

    public String getName() {
        return "JavaScript";
    }

    public String getGroup() {
        return "Rule Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public JSPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        JSPolicyRepresentation representation = new JSPolicyRepresentation();
        representation.setCode((String)policy.getConfig().get("code"));
        return representation;
    }

    public Class<JSPolicyRepresentation> getRepresentationType() {
        return JSPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, JSPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.throwCanNotUpdatePolicy(authorization);
    }

    public void onUpdate(Policy policy, JSPolicyRepresentation representation, AuthorizationProvider authorization) {
        policy.setDecisionStrategy(representation.getDecisionStrategy());
        policy.setDescription(policy.getDescription());
        policy.setLogic(policy.getLogic());
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        this.throwCanNotUpdatePolicy(authorization);
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
        this.scriptCache.remove(policy.getId());
    }

    public void init(Config.Scope config) {
        int maxEntries = Integer.parseInt(config.get("cache-max-entries", "100"));
        int maxAge = Integer.parseInt(config.get("cache-entry-max-age", "-1"));
        this.scriptCache = new ScriptCache(maxEntries, maxAge);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "js";
    }

    public boolean isInternal() {
        return true;
    }

    private EvaluatableScriptAdapter getEvaluatableScript(AuthorizationProvider authz, Policy policy) {
        return this.scriptCache.computeIfAbsent(policy.getId(), id -> {
            ScriptingProvider scripting = (ScriptingProvider)authz.getKeycloakSession().getProvider(ScriptingProvider.class);
            ScriptModel script = this.getScriptModel(policy, authz.getRealm(), scripting);
            return scripting.prepareEvaluatableScript(script);
        });
    }

    protected ScriptModel getScriptModel(Policy policy, RealmModel realm, ScriptingProvider scripting) {
        String scriptName = policy.getName();
        String scriptCode = (String)policy.getConfig().get("code");
        String scriptDescription = policy.getDescription();
        return scripting.createScript(realm.getId(), "text/javascript", scriptName, scriptCode, scriptDescription);
    }

    protected boolean isDeployed() {
        return false;
    }

    private void throwCanNotUpdatePolicy(AuthorizationProvider authorization) {
        if (!((Boolean)authorization.getKeycloakSession().getAttributeOrDefault("ALLOW_CREATE_POLICY", (Object)false)).booleanValue() && !this.isDeployed()) {
            throw new RuntimeException("Script upload is disabled");
        }
    }
}

