/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.js;

import java.util.Map;
import javax.script.ScriptEngineManager;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.js.JSPolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;

public class JSPolicyProviderFactory
implements PolicyProviderFactory<JSPolicyRepresentation> {
    private static final String ENGINE = "nashorn";
    private JSPolicyProvider provider = new JSPolicyProvider(() -> new ScriptEngineManager().getEngineByName(ENGINE));

    public String getName() {
        return "JavaScript";
    }

    public String getGroup() {
        return "Rule Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public JSPolicyRepresentation toRepresentation(Policy policy, JSPolicyRepresentation representation) {
        representation.setCode((String)policy.getConfig().get("code"));
        return representation;
    }

    public Class<JSPolicyRepresentation> getRepresentationType() {
        return JSPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, JSPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation.getCode());
    }

    public void onUpdate(Policy policy, JSPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation.getCode());
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, (String)representation.getConfig().get("code"));
    }

    private void updatePolicy(Policy policy, String code) {
        Map config = policy.getConfig();
        config.put("code", code);
        policy.setConfig(config);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "js";
    }
}

