/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.drools;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicy;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyAdminResource;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderFactory;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class DroolsPolicyProviderFactory
implements PolicyProviderFactory {
    private KieServices ks;
    private final Map<String, DroolsPolicy> containers = new HashMap<String, DroolsPolicy>();

    public String getName() {
        return "Rule";
    }

    public String getGroup() {
        return "Rule Based";
    }

    public PolicyProvider create(Policy policy, AuthorizationProvider authorization) {
        if (!this.containers.containsKey(policy.getId())) {
            this.update(policy);
        }
        return new DroolsPolicyProvider(this.containers.get(policy.getId()));
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer) {
        return new DroolsPolicyAdminResource(resourceServer, this);
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
        this.ks = KieServices.Factory.get();
    }

    public void postInit(final KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
                    AuthorizationProvider authorization = (AuthorizationProvider)providerFactory.create(factory.create());
                    authorization.getStoreFactory().getPolicyStore().findByType(DroolsPolicyProviderFactory.this.getId()).forEach(DroolsPolicyProviderFactory.this::update);
                }
            }
        });
    }

    public void close() {
        this.containers.values().forEach(DroolsPolicy::dispose);
        this.containers.clear();
    }

    public String getId() {
        return "drools";
    }

    void update(Policy policy) {
        this.remove(policy);
        this.containers.put(policy.getId(), new DroolsPolicy(this.ks, policy));
    }

    void remove(Policy policy) {
        DroolsPolicy holder = this.containers.remove(policy.getId());
        if (holder != null) {
            holder.dispose();
        }
    }

    KieContainer getKieContainer(String groupId, String artifactId, String version) {
        return this.ks.newKieContainer(this.ks.newReleaseId(groupId, artifactId, version));
    }
}

