/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.admin.cli.commands.AbstractGlobalOptionsCmd;
import org.keycloak.client.admin.cli.common.AttributeOperation;
import org.keycloak.client.admin.cli.common.CmdStdinContext;
import org.keycloak.client.admin.cli.util.AccessibleBufferOutputStream;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.OsUtil;
import org.keycloak.client.admin.cli.util.OutputUtil;
import org.keycloak.client.admin.cli.util.ParseUtil;

@CommandDefinition(name="new-object", description="Command to create new JSON objects locally")
public class NewObjectCmd
extends AbstractGlobalOptionsCmd {
    @Option(shortName=102, name="file", description="Read object from file or standard input if FILENAME is set to '-'", hasValue=true)
    String file;
    @Option(shortName=99, name="compressed", description="Don't pretty print the output", hasValue=false)
    boolean compressed;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            CommandResult commandResult = this.process(commandInvocation);
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    public CommandResult process(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        LinkedList<AttributeOperation> attrs = new LinkedList<AttributeOperation>();
        Iterator it = this.args.iterator();
        block9: while (it.hasNext()) {
            String option;
            switch (option = (String)it.next()) {
                case "-s": 
                case "--set": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException("Option " + option + " requires a value");
                    }
                    String[] keyVal = ParseUtil.parseKeyVal((String)it.next());
                    attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Invalid option: " + option);
        }
        ByteArrayInputStream body = null;
        CmdStdinContext<Object> ctx = new CmdStdinContext();
        if (this.file != null) {
            ctx = ParseUtil.parseFileOrStdin(this.file);
        }
        if (attrs.size() > 0) {
            ctx = ParseUtil.mergeAttributes(ctx, OutputUtil.MAPPER.createObjectNode(), attrs);
        }
        if (body == null && ctx.getContent() != null) {
            body = new ByteArrayInputStream(ctx.getContent().getBytes(Charset.forName("utf-8")));
        }
        AccessibleBufferOutputStream abos = new AccessibleBufferOutputStream(System.out);
        if (!this.compressed) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            IoUtil.copyStream(body, buffer);
            try {
                JsonNode rootNode = OutputUtil.MAPPER.readValue(buffer.toByteArray(), JsonNode.class);
                OutputUtil.MAPPER.writeValue(abos, (Object)rootNode);
            }
            catch (Exception ignored) {
                IoUtil.copyStream(new ByteArrayInputStream(buffer.toByteArray()), abos);
            }
        } else {
            IoUtil.copyStream(body, System.out);
        }
        int lastByte = abos.getLastByte();
        if (lastByte != -1 && lastByte != 13 && lastByte != 10) {
            IoUtil.printErr("");
        }
        return CommandResult.SUCCESS;
    }

    @Override
    protected boolean nothingToDo() {
        return this.file == null && (this.args == null || this.args.size() == 0);
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help create' for more information";
    }

    @Override
    protected String help() {
        return NewObjectCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " new-object [ARGUMENTS]");
        out.println();
        out.println("Command to compose JSON objects from attributes, and merge changes into existing JSON documents.");
        out.println();
        out.println("This is a local command that does not perform any server requests. It's functionality is fully ");
        out.println("integrated into 'create', 'update' and 'delete' commands. It's supposed to be a helper tool only.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println();
        out.println("  Command specific options:");
        out.println("    -s, --set NAME=VALUE  Set a specific attribute NAME to a specified value VALUE");
        out.println("    -f, --file FILENAME   Read object from file or standard input if FILENAME is set to '-'");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Create a new JSON document with two top level attributes:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " new-object -s realm=demorealm -s enabled=true");
        out.println();
        out.println("Read a JSON document and apply changes on top of it:");
        if (OsUtil.OS_ARCH.isWindows()) {
            out.println("  " + OsUtil.PROMPT + " echo { \"clientId\": \"my_client\" } | " + OsUtil.CMD + " new-object -s enabled=true -f -");
        } else {
            out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " new-object -s enabled=true -f - << EOF");
            out.println("  {");
            out.println("    \"clientId\": \"my_client\"");
            out.println("  }");
            out.println("  EOF");
        }
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

