/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.common;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AttributeKey {
    private static final int START = 0;
    private static final int QUOTED = 1;
    private static final int UNQUOTED = 2;
    private static final int END = 3;
    private List<Component> components;
    private boolean append;

    public AttributeKey() {
        this.components = Collections.emptyList();
    }

    public AttributeKey(String key) {
        if (key.endsWith("+")) {
            this.append = true;
            key = key.substring(0, key.length() - 1);
        }
        this.components = AttributeKey.parse(key);
    }

    static List<Component> parse(String key) {
        if (key == null || "".equals(key)) {
            return Collections.emptyList();
        }
        LinkedList<Component> cs = new LinkedList<Component>();
        StringBuilder sb = new StringBuilder();
        int state = 0;
        char[] buf = key.toCharArray();
        for (int pos = 0; pos < buf.length; ++pos) {
            char c = buf[pos];
            if (state == 0) {
                if ('\"' == c) {
                    state = 1;
                    continue;
                }
                if ('.' == c) {
                    throw new RuntimeException("Invalid attribute key: " + key + " (at position " + (pos + 1) + ")");
                }
                state = 2;
                sb.append(c);
                continue;
            }
            if (state == 1) {
                if ('\"' == c) {
                    state = 3;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (state != 2 && state != 3) continue;
            if ('.' == c) {
                state = 0;
                cs.add(new Component(sb.toString()));
                sb.setLength(0);
                continue;
            }
            if (state == 3 || '\"' == c) {
                throw new RuntimeException("Invalid attribute key: " + key + " (at position " + (pos + 1) + ")");
            }
            sb.append(c);
        }
        boolean ok = false;
        if (sb.length() > 0) {
            if (state == 2 || state == 3) {
                cs.add(new Component(sb.toString()));
                ok = true;
            }
        } else if (state == 3) {
            ok = true;
        }
        if (!ok) {
            throw new RuntimeException("Invalid attribute key: " + key + " (at position " + buf.length + ")");
        }
        return Collections.unmodifiableList(cs);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public boolean isAppend() {
        return this.append;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Component c : this.components) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(c.toString());
        }
        return sb.toString();
    }

    public static class Component {
        private int index = -1;
        private String name;

        Component(String name) {
            if (name.endsWith("]")) {
                int pos = name.lastIndexOf("[", name.length() - 1);
                if (pos == -1) {
                    throw new RuntimeException("Invalid attribute key: " + name + " (']' not allowed here)");
                }
                String idx = name.substring(pos + 1, name.length() - 1);
                try {
                    this.index = Integer.parseInt(idx);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid attribute key: " + name + " (Invalid array index: '[" + idx + "]')");
                }
                this.name = name.substring(0, pos);
            } else {
                this.name = name;
            }
        }

        public boolean isArray() {
            return this.index >= 0;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + (this.index != -1 ? "[" + this.index + "]" : "");
        }
    }
}

